/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.informix.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.informix.tab.InformixSourceTab;

public class ProcedureSourceTab
extends InformixSourceTab {
    private static String SQL = "SELECT T1.procid, T2.data, T2.seqno FROM informix.sysprocedures AS T1, informix.sysprocbody AS T2 WHERE procname = ? AND T2.procid = T1.procid AND datakey = 'T' ORDER BY T1.procid, T2.seqno ";
    private static final ILogger s_log = LoggerController.createLogger(ProcedureSourceTab.class);

    public ProcedureSourceTab(String hint) {
        super(hint);
        this.sourceType = 1;
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Running SQL: " + SQL));
            s_log.debug((Object)("procname=" + doi.getSimpleName()));
        }
        ISQLConnection conn = session.getSQLConnection();
        PreparedStatement pstmt = conn.prepareStatement(SQL);
        pstmt.setString(1, doi.getSimpleName());
        return pstmt;
    }
}

