/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.util.DiffUtil;

public class ScrollSynchronizer {
    private BufferDiffPanel diffPanel;
    private FilePanel filePanelLeft;
    private FilePanel filePanelRight;
    private AdjustmentListener horizontalAdjustmentListener;
    private AdjustmentListener verticalAdjustmentListener;

    public ScrollSynchronizer(BufferDiffPanel diffPanel, FilePanel filePanelLeft, FilePanel filePanelRight) {
        this.diffPanel = diffPanel;
        this.filePanelLeft = filePanelLeft;
        this.filePanelRight = filePanelRight;
        this.init();
    }

    private void init() {
        JScrollBar o = this.filePanelLeft.getScrollPane().getHorizontalScrollBar();
        JScrollBar r = this.filePanelRight.getScrollPane().getHorizontalScrollBar();
        r.addAdjustmentListener(this.getHorizontalAdjustmentListener());
        o.addAdjustmentListener(this.getHorizontalAdjustmentListener());
        o = this.filePanelLeft.getScrollPane().getVerticalScrollBar();
        r = this.filePanelRight.getScrollPane().getVerticalScrollBar();
        r.addAdjustmentListener(this.getVerticalAdjustmentListener());
        o.addAdjustmentListener(this.getVerticalAdjustmentListener());
    }

    private void scroll(boolean leftScrolled) {
        FilePanel fp2;
        FilePanel fp1;
        JMRevision revision = this.diffPanel.getCurrentRevision();
        if (revision == null) {
            return;
        }
        if (leftScrolled) {
            fp1 = this.filePanelLeft;
            fp2 = this.filePanelRight;
        } else {
            fp1 = this.filePanelRight;
            fp2 = this.filePanelLeft;
        }
        int line = this.getCurrentLineCenter(fp1);
        line = leftScrolled ? DiffUtil.getRevisedLine(revision, line) : DiffUtil.getOriginalLine(revision, line);
        this.scrollToLine(fp2, line);
    }

    void toNextDelta(boolean next) {
        JMDelta toDelta;
        JMRevision revision = this.diffPanel.getCurrentRevision();
        if (revision == null) {
            return;
        }
        List<JMDelta> deltas = revision.getDeltas();
        int line = this.getCurrentLineCenter(this.filePanelLeft);
        JMDelta currentDelta = null;
        int currentIndex = -1;
        int i = 0;
        for (JMDelta delta : deltas) {
            JMChunk original = delta.getOriginal();
            currentIndex = i++;
            if (line < original.getAnchor()) break;
            if (line > original.getAnchor() + original.getSize()) continue;
            currentDelta = delta;
            break;
        }
        JMDelta previousDelta = null;
        JMDelta nextDelta = null;
        if (currentIndex != -1) {
            if (currentIndex > 0) {
                previousDelta = deltas.get(currentIndex - 1);
            }
            int nextIndex = currentIndex;
            if (currentDelta != null) {
                ++nextIndex;
            }
            if (nextIndex < deltas.size()) {
                nextDelta = deltas.get(nextIndex);
            }
        }
        if ((toDelta = next ? nextDelta : previousDelta) != null) {
            this.scrollToLine(this.filePanelLeft, toDelta.getOriginal().getAnchor());
            this.scroll(true);
        }
    }

    void showDelta(JMDelta delta) {
        this.scrollToLine(this.filePanelLeft, delta.getOriginal().getAnchor());
        this.scroll(true);
    }

    private int getCurrentLineCenter(FilePanel fp) {
        JTextArea editor = fp.getEditor();
        JScrollPane scrollPane = fp.getScrollPane();
        JViewport viewport = scrollPane.getViewport();
        Point p = viewport.getViewPosition();
        int offset = editor.viewToModel(p);
        p.y += this.getHeightOffset(fp);
        offset = editor.viewToModel(p);
        BufferDocumentIF bd = fp.getBufferDocument();
        if (bd == null) {
            return -1;
        }
        int line = bd.getLineForOffset(offset);
        return line;
    }

    public void scrollToLine(FilePanel fp, int line) {
        FilePanel fp2 = fp == this.filePanelLeft ? this.filePanelRight : this.filePanelLeft;
        BufferDocumentIF bd = fp.getBufferDocument();
        if (bd == null) {
            return;
        }
        int offset = bd.getOffsetForLine(line);
        if (offset < 0) {
            return;
        }
        JViewport viewport = fp.getScrollPane().getViewport();
        JTextArea editor = fp.getEditor();
        try {
            Rectangle rect = editor.modelToView(offset);
            if (rect == null) {
                return;
            }
            Point p = rect.getLocation();
            p.y -= this.getHeightOffset(fp);
            p.y += this.getCorrectionOffset(fp2);
            if (p.y < 0) {
                p.y = 0;
            }
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            Dimension extentSize = viewport.getExtentSize();
            if (p.y > viewSize.height - extentSize.height) {
                p.y = viewSize.height - extentSize.height;
            }
            p.x = viewRect.x;
            viewport.setViewPosition(p);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int getHeightOffset(FilePanel fp) {
        JScrollPane scrollPane = fp.getScrollPane();
        JViewport viewport = scrollPane.getViewport();
        int offset = viewport.getSize().height / 2;
        int unitIncrement = scrollPane.getHorizontalScrollBar().getUnitIncrement();
        offset -= offset % unitIncrement;
        return offset;
    }

    private int getCorrectionOffset(FilePanel fp) {
        JTextArea editor = fp.getEditor();
        JViewport viewport = fp.getScrollPane().getViewport();
        Point p = viewport.getViewPosition();
        int offset = editor.viewToModel(p);
        try {
            Rectangle rect = editor.modelToView(offset);
            if (rect != null) {
                return p.y - rect.getLocation().y;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0;
    }

    private AdjustmentListener getHorizontalAdjustmentListener() {
        if (this.horizontalAdjustmentListener == null) {
            this.horizontalAdjustmentListener = new AdjustmentListener(){
                private boolean insideScroll;

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    JScrollBar scTo;
                    JScrollBar scFrom;
                    if (this.insideScroll) {
                        return;
                    }
                    if (ScrollSynchronizer.this.filePanelLeft.getScrollPane().getHorizontalScrollBar() == e.getSource()) {
                        scFrom = ScrollSynchronizer.this.filePanelLeft.getScrollPane().getHorizontalScrollBar();
                        scTo = ScrollSynchronizer.this.filePanelRight.getScrollPane().getHorizontalScrollBar();
                    } else {
                        scFrom = ScrollSynchronizer.this.filePanelRight.getScrollPane().getHorizontalScrollBar();
                        scTo = ScrollSynchronizer.this.filePanelLeft.getScrollPane().getHorizontalScrollBar();
                    }
                    this.insideScroll = true;
                    this.insideScroll = true;
                    scTo.setValue(scFrom.getValue());
                    this.insideScroll = false;
                }
            };
        }
        return this.horizontalAdjustmentListener;
    }

    private AdjustmentListener getVerticalAdjustmentListener() {
        if (this.verticalAdjustmentListener == null) {
            this.verticalAdjustmentListener = new AdjustmentListener(){
                private boolean insideScroll;
                private int counter;

                public void adjustmentValueChanged(AdjustmentEvent e) {
                    if (this.insideScroll) {
                        return;
                    }
                    boolean leftScrolled = ScrollSynchronizer.this.filePanelLeft.getScrollPane().getVerticalScrollBar() == e.getSource();
                    this.insideScroll = true;
                    ScrollSynchronizer.this.scroll(leftScrolled);
                    this.insideScroll = false;
                }
            };
        }
        return this.verticalAdjustmentListener;
    }
}

