/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Sqrt
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Sqrt(Expression expression) {
        this.expr = expression;
        this.returnType = 8;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return new Double(Math.sqrt(((Number)object).doubleValue()));
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "SQRT";
    }

    @Override
    public String toString(Relation relation) {
        return "SQRT(" + this.expr.toString(relation) + ")";
    }
}

