/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaDataFactory;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.postgres.IObjectTypes;
import net.sourceforge.squirrel_sql.plugins.postgres.actions.VacuumDatabaseAction;
import net.sourceforge.squirrel_sql.plugins.postgres.actions.VacuumTableAction;
import net.sourceforge.squirrel_sql.plugins.postgres.exp.PostgresSequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.exp.PostgresTableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.postgres.exp.PostgresTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.postgres.explain.ExplainExecuterPanel;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.ActiveConnections;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.IndexSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.LockTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlArrayTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlGeometryTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlOtherTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlUUIDTypeDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlXmlTypeDataTypeComponentFactory;

public class PostgresPlugin
extends DefaultSessionPlugin
implements ISQLDatabaseMetaDataFactory {
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private static final ILogger s_log = LoggerController.createLogger(PostgresPlugin.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PostgresPlugin.class);

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "postgres";
    }

    public String getDescriptiveName() {
        return "Postgres Plugin";
    }

    public String getVersion() {
        return "0.22";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Daniel Regli, Yannick Winiger, Jaros\u0142aw Jarmo\u0142owicz";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        this._resources = this._resourcesFactory.createResource(((Object)((Object)this)).getClass().getName(), (IPlugin)this);
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        ActionCollection col = this.getApplication().getActionCollection();
        col.add((Action)((Object)new VacuumTableAction(app, this._resources)));
        col.add((Action)((Object)new VacuumDatabaseAction(app, this._resources)));
        JMenu sessionMenu = this.createSessionMenu(col);
        app.addToMenu(2, sessionMenu);
        super.registerSessionMenu(sessionMenu);
        CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlGeometryTypeDataTypeComponentFactory(app.getSessionManager()));
        CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlUUIDTypeDataTypeComponentFactory());
        CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlArrayTypeDataTypeComponentFactory());
        CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlXmlTypeDataTypeComponentFactory());
        CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new PostgreSqlOtherTypeDataTypeComponentFactory("interval"));
        SQLDatabaseMetaDataFactory.registerOverride((DialectType)DialectType.POSTGRES, (ISQLDatabaseMetaDataFactory)this);
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PostgresPlugin.this.updateTreeApi(session);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                session.getSQLPanelAPIOfActiveSessionWindow().addExecutor((ISQLResultExecuter)new ExplainExecuterPanel(session));
            }
        });
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(final SQLInternalFrame sqlInternalFrame, final ISession sess) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        sqlInternalFrame.getSQLPanelAPI().addExecutor((ISQLResultExecuter)new ExplainExecuterPanel(sess));
                    }
                });
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isPostgreSQL((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(ISession session) {
        IObjectTreeAPI _treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        String stmtSep = session.getQueryTokenizer().getSQLStatementSeparator();
        ActionCollection col = this.getApplication().getActionCollection();
        _treeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new PostgresSequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE));
        TableWithChildNodesExpander tableExpander = new TableWithChildNodesExpander();
        PostgresTableIndexExtractorImpl indexExtractor = new PostgresTableIndexExtractorImpl();
        PostgresTableTriggerExtractorImpl triggerExtractor = new PostgresTableTriggerExtractorImpl();
        tableExpander.setTableTriggerExtractor((ITableTriggerExtractor)triggerExtractor);
        tableExpander.setTableIndexExtractor((ITableIndexExtractor)indexExtractor);
        _treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExpander);
        _treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE));
        _treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE, stmtSep));
        _treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        _treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        _treeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexSourceTab(i18n.SHOW_INDEX_SOURCE, stmtSep));
        _treeAPI.addDetailTab(IObjectTypes.TRIGGER_PARENT, (IObjectTab)new DatabaseObjectInfoTab());
        _treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        _treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        _treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
        _treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        _treeAPI.addDetailTab(DatabaseObjectType.SEQUENCE_TYPE_DBO, (IObjectTab)new SequenceDetailsTab());
        _treeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new LockTab());
        _treeAPI.addDetailTab(DatabaseObjectType.SESSION, (IObjectTab)new ActiveConnections());
        JMenu tableMenu = this._resources.createMenu("postgres");
        this._resources.addToMenu(col.get(VacuumTableAction.class), tableMenu);
        _treeAPI.addToPopup(DatabaseObjectType.TABLE, tableMenu);
        _treeAPI.addToPopup(DatabaseObjectType.SESSION, this.createSessionMenu(col));
    }

    private JMenu createSessionMenu(ActionCollection col) {
        JMenu sessionMenu = this._resources.createMenu("postgres");
        this._resources.addToMenu(col.get(VacuumDatabaseAction.class), sessionMenu);
        return sessionMenu;
    }

    public SQLDatabaseMetaData fetchMeta(final ISQLConnection conn) {
        return new SQLDatabaseMetaData(conn){
            private Map<String, Boolean> oidSupportForTable;
            {
                super(x0);
                this.oidSupportForTable = new HashMap<String, Boolean>();
            }

            public String getOptionalPseudoColumnForDataSelection(ITableInfo ti) {
                Boolean supports = this.oidSupportForTable.get(ti.getQualifiedName());
                if (supports == null) {
                    supports = false;
                    try {
                        ResultSet rs = conn.createStatement().executeQuery("SELECT TRUE FROM   pg_attribute WHERE  attrelid = '" + ti.getQualifiedName() + "'::regclass AND    attname = 'oid' AND NOT attisdropped");
                        if (rs.next()) {
                            supports = true;
                        }
                    }
                    catch (SQLException sqlE) {
                        s_log.error((Object)"During oid existance checking", (Throwable)sqlE);
                    }
                    this.oidSupportForTable.put(ti.getQualifiedName(), supports);
                }
                return supports != false ? "oid" : null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized String[] getDataTypesSimpleNames() throws SQLException {
                String sql = "SELECT t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON (t.typnamespace = n.oid)  WHERE n.nspname != 'pg_toast'  AND typelem = 0 AND typrelid = 0";
                ArrayList<String> retn = new ArrayList<String>();
                ResultSet rs = conn.createStatement().executeQuery(sql);
                try {
                    while (rs.next()) {
                        retn.add(rs.getString(1));
                    }
                }
                finally {
                    SQLUtilities.closeResultSet((ResultSet)rs);
                }
                return retn.toArray(new String[retn.size()]);
            }
        };
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    public static interface IMenuResourceKeys {
        public static final String POSTGRES = "postgres";
    }

    static interface i18n {
        public static final String SHOW_INDEX_SOURCE = PostgresPlugin.access$000().getString("PostgresPlugin.showIndexSource");
        public static final String SHOW_VIEW_SOURCE = PostgresPlugin.access$000().getString("PostgresPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = PostgresPlugin.access$000().getString("PostgresPlugin.showProcedureSource");
    }
}

