/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util;

import java.awt.Color;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color getOpposite(Color color) {
        return ColorUtil.isDark(color) ? Color.WHITE : Color.BLACK;
    }

    public static Color shade(Color color, double d) {
        return ColorUtil.blend(color, ColorUtil.getOpposite(color), d);
    }

    public static final Color mult(Color color, double d) {
        return color == null ? null : new Color(Math.min(255, (int)((double)color.getRed() * d)), Math.min(255, (int)((double)color.getGreen() * d)), Math.min(255, (int)((double)color.getBlue() * d)), color.getAlpha());
    }

    public static Color setAlpha(Color color, int n) {
        return color == null ? null : new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static final Color add(Color color, Color color2) {
        return color == null ? color2 : (color2 == null ? color : new Color(Math.min(255, color.getRed() + color2.getRed()), Math.min(255, color.getGreen() + color2.getGreen()), Math.min(255, color.getBlue() + color2.getBlue()), color.getAlpha()));
    }

    public static Color blend(Color color, Color color2, double d) {
        double d2 = 1.0 - d;
        return color == null ? (color2 == null ? null : color2) : (color2 == null ? color : new Color(Math.min(255, (int)((double)color.getRed() * d2 + (double)color2.getRed() * d)), Math.min(255, (int)((double)color.getGreen() * d2 + (double)color2.getGreen() * d)), Math.min(255, (int)((double)color.getBlue() * d2 + (double)color2.getBlue() * d)), Math.min(255, (int)((double)color.getAlpha() * d2 + (double)color2.getAlpha() * d))));
    }

    public static boolean isDark(Color color) {
        return color.getRed() + color.getGreen() + color.getBlue() < 540;
    }

    public static Color highlight(Color color) {
        return ColorUtil.mult(color, ColorUtil.isDark(color) ? 1.5 : (double)0.67f);
    }

    public static Color copy(Color color) {
        return color == null ? null : new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

