/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.SybaseASE.exception;

import java.sql.SQLWarning;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;

public class SybaseASEExceptionFormatter
implements ExceptionFormatter {
    private final DefaultExceptionFormatter defaultFormatter = new DefaultExceptionFormatter();

    public String format(Throwable t) throws Exception {
        if (t instanceof SQLWarning) {
            SQLWarning warning = (SQLWarning)t;
            return this.defaultFormatWarningMessage(warning);
        }
        return this.defaultFormatter.format(t);
    }

    private String defaultFormatWarningMessage(SQLWarning warning) {
        String nullString = "null";
        StringBuilder result = new StringBuilder();
        result.append("SQLWarning: ");
        result.append("ErrorCode: ");
        String errorCodeS = "" + warning.getErrorCode();
        for (int i = 6; i > errorCodeS.length(); --i) {
            result.append(' ');
        }
        result.append(errorCodeS);
        result.append(" SQLState: ");
        String sqlState = warning.getSQLState();
        result.append(null == sqlState ? "null" : sqlState.trim());
        result.append(" --- ");
        String message = warning.getMessage();
        result.append(null == message ? "null" : message.trim());
        return result.toString();
    }

    public boolean formatsException(Throwable t) {
        return this.defaultFormatter.formatsException(t);
    }
}

