/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.ISquirrelSearchDialog;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.LastFindHelper;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.search.SearchDialogClosingListener;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;

public class SquirrelReplaceDialog
extends ReplaceDialog
implements ISquirrelSearchDialog {
    private ArrayList<SearchDialogClosingListener> _closingListeners = new ArrayList();
    private ArrayList<ActionListener> _replaceListeners = new ArrayList();
    private ArrayList<ActionListener> _replaceAllListeners = new ArrayList();
    private SquirrelRSyntaxTextArea _squirrelRSyntaxTextArea;

    public SquirrelReplaceDialog(Frame owner, SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        super(owner, (SearchListener)new SearchListenerProxy());
        SearchListenerProxy proxy = (SearchListenerProxy)this.searchListener;
        proxy.setDelegate(this);
        this._squirrelRSyntaxTextArea = squirrelRSyntaxTextArea;
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SquirrelReplaceDialog.this.close();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SquirrelReplaceDialog.this.onClosing();
            }
        });
        LastFindHelper.loadLastFinds(this.findTextCombo);
    }

    private void onClosing() {
        LastFindHelper.storeLastFinds(this.findTextCombo);
        this.fireClosing();
    }

    protected void escapePressed() {
        this.close();
        super.escapePressed();
    }

    @Override
    public void close() {
        LastFindHelper.storeLastFinds(this.findTextCombo);
        this.fireClosing();
        this.setVisible(false);
        this.dispose();
    }

    private void fireClosing() {
        SearchDialogClosingListener[] listeners;
        for (SearchDialogClosingListener listener : listeners = this._closingListeners.toArray(new SearchDialogClosingListener[this._closingListeners.size()])) {
            listener.searchDialogClosing();
        }
    }

    @Override
    public boolean isMatchCase() {
        return this.caseCheckBox.isSelected();
    }

    @Override
    public boolean isWholeWord() {
        return this.wholeWordCheckBox.isSelected();
    }

    @Override
    public boolean isRegExp() {
        return this.getSearchContext().isRegularExpression();
    }

    @Override
    public boolean isSearchUp() {
        return this.upButton.isSelected();
    }

    @Override
    public boolean isMarkAll() {
        return this.markAllCheckBox.isSelected();
    }

    @Override
    public JDialog getDialog() {
        return this;
    }

    @Override
    public void addClosingListener(SearchDialogClosingListener l) {
        this._closingListeners.add(l);
    }

    @Override
    public void removeClosingListener(SearchDialogClosingListener l) {
        this._closingListeners.remove(l);
    }

    @Override
    public void addFindActionListener(ActionListener actionListener) {
        this.findNextButton.addActionListener(actionListener);
    }

    @Override
    public void removeFindActionListener(ActionListener actionListener) {
        this.findNextButton.removeActionListener(actionListener);
    }

    @Override
    public void addReplaceActionListener(ActionListener actionListener) {
        this._replaceListeners.remove(actionListener);
        this._replaceListeners.add(actionListener);
    }

    private void onReplace() {
        this.fireActionListeners(this._replaceListeners);
    }

    private void onReplaceAll() {
        this.fireActionListeners(this._replaceAllListeners);
    }

    private void fireActionListeners(ArrayList<ActionListener> replacelisteners) {
        ActionListener[] listeners;
        for (ActionListener listener : listeners = replacelisteners.toArray(new ActionListener[replacelisteners.size()])) {
            listener.actionPerformed(null);
        }
    }

    @Override
    public void removeReplaceActionListener(ActionListener actionListener) {
        this._replaceListeners.remove(actionListener);
    }

    private void removeReplaceListener(ActionListener actionListener) {
        this._replaceAllListeners.remove(actionListener);
    }

    @Override
    public void addReplaceAllActionListener(ActionListener actionListener) {
        this._replaceAllListeners.remove(actionListener);
        this._replaceAllListeners.add(actionListener);
    }

    @Override
    public void removeReplaceAllActionListener(ActionListener actionListener) {
        this.removeReplaceListener(actionListener);
    }

    private static class SearchListenerProxy
    implements SearchListener {
        private SquirrelReplaceDialog _delegate;

        private SearchListenerProxy() {
        }

        public void searchEvent(SearchEvent searchEvent) {
            if (SearchEvent.Type.REPLACE == searchEvent.getType()) {
                this._delegate.onReplace();
            } else if (SearchEvent.Type.REPLACE_ALL == searchEvent.getType()) {
                this._delegate.onReplaceAll();
            }
        }

        public String getSelectedText() {
            return this._delegate._squirrelRSyntaxTextArea.getSelectedText();
        }

        public void setDelegate(SquirrelReplaceDialog squirrelReplaceDialog) {
            this._delegate = squirrelReplaceDialog;
        }
    }
}

