/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript.kernel;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ClassPathEntry;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.GenerateTemplateController;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.Script;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptListDialog;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptListTableModel;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptPropertiesController;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptProps;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptPropsAdapter;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptTargetCollection;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.UserScriptAdmin;

public class ScriptListController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ScriptListController.class);
    private ScriptListDialog m_dlg;
    private JFrame m_ownerFrame;
    private UserScriptAdmin m_admin;
    private ScriptTargetCollection m_targets;

    public ScriptListController(JFrame ownerFrame, UserScriptAdmin admin, boolean targetType) {
        try {
            String applicableScriptsText;
            String title;
            this.m_admin = admin;
            this.m_ownerFrame = ownerFrame;
            this.m_targets = this.m_admin.getTargets(targetType);
            if (1 < this.m_targets.size()) {
                title = s_stringMgr.getString("userscript.execOnTargets");
                applicableScriptsText = s_stringMgr.getString("userscript.applicableToTarget");
            } else {
                title = s_stringMgr.getString("userscript.execOn", new Object[]{this.m_targets.getAll()[0].getTargetInfo()});
                applicableScriptsText = s_stringMgr.getString("userscript.applicableTo", new Object[]{this.m_targets.getAll()[0].getTargetInfo()});
            }
            this.m_dlg = new ScriptListDialog((Frame)ownerFrame, title, applicableScriptsText);
            GUIUtils.centerWithinParent((Window)this.m_dlg);
            this.m_dlg.setVisible(true);
            ScriptProps props = this.m_admin.readScriptProps();
            if (null != props) {
                ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
                tm.setScripts(props.getScripts());
                Vector<String> extraClassPath = new Vector<String>();
                for (int i = 0; i < props.getExtraClassPath().length; ++i) {
                    extraClassPath.add(props.getExtraClassPath()[i].getEntry());
                }
                this.m_dlg.lstExtraClasspath.setListData(extraClassPath);
            }
            this.m_dlg.btnExecute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onExecute();
                }
            });
            this.m_dlg.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onAdd();
                }
            });
            this.m_dlg.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onEdit();
                }
            });
            this.m_dlg.btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onRemove();
                }
            });
            this.m_dlg.btnCpAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onCpAdd();
                }
            });
            this.m_dlg.btnCpRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onCpRemove();
                }
            });
            this.m_dlg.btnGenerateTemplate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptListController.this.onGenerateTemplate();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onGenerateTemplate() {
        new GenerateTemplateController(this.m_ownerFrame);
    }

    private void onCpRemove() {
        int[] selIndices = this.m_dlg.lstExtraClasspath.getSelectedIndices();
        if (0 == selIndices.length) {
            JOptionPane.showMessageDialog(this.m_ownerFrame, s_stringMgr.getString("userscript.selClasspathToDel"));
            return;
        }
        Vector remainEntries = new Vector();
        for (int i = 0; i < this.m_dlg.lstExtraClasspath.getModel().getSize(); ++i) {
            boolean found = false;
            for (int j = 0; j < selIndices.length; ++j) {
                if (i != selIndices[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            remainEntries.add(this.m_dlg.lstExtraClasspath.getModel().getElementAt(i));
        }
        this.m_dlg.lstExtraClasspath.setListData(remainEntries);
        this.saveScriptProps();
        this.m_admin.refreshExtraClassPath();
    }

    private void onCpAdd() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        if (0 == fc.showOpenDialog(this.m_ownerFrame)) {
            Vector<String> extraClassPath = new Vector<String>();
            for (int i = 0; i < this.m_dlg.lstExtraClasspath.getModel().getSize(); ++i) {
                extraClassPath.add((String)this.m_dlg.lstExtraClasspath.getModel().getElementAt(i));
            }
            File[] files = fc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                extraClassPath.add(files[i].getPath());
            }
            this.m_dlg.lstExtraClasspath.setListData(extraClassPath);
        }
        this.saveScriptProps();
        this.m_admin.refreshExtraClassPath();
    }

    private void onExecute() {
        if (-1 == this.m_dlg.tblScriptList.getSelectedRow()) {
            JOptionPane.showMessageDialog(this.m_ownerFrame, s_stringMgr.getString("userscript.selScriptToExec"));
            return;
        }
        ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
        Script selScript = tm.getScripts()[this.m_dlg.tblScriptList.getSelectedRow()];
        this.m_admin.executeScript(this.m_ownerFrame, selScript, this.m_targets);
    }

    private void onRemove() {
        if (-1 == this.m_dlg.tblScriptList.getSelectedRow()) {
            JOptionPane.showMessageDialog(this.m_ownerFrame, s_stringMgr.getString("userscript.selScriptToDel"));
            return;
        }
        ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
        Script selScript = tm.getScripts()[this.m_dlg.tblScriptList.getSelectedRow()];
        int option = JOptionPane.showConfirmDialog(this.m_ownerFrame, s_stringMgr.getString("userscript.confirmRemove", new Object[]{selScript.getName()}));
        if (0 == option) {
            tm.remove(this.m_dlg.tblScriptList.getSelectedRow());
            this.saveScriptProps();
        }
    }

    private void onEdit() {
        if (-1 == this.m_dlg.tblScriptList.getSelectedRow()) {
            JOptionPane.showMessageDialog(this.m_ownerFrame, s_stringMgr.getString("userscript.selScriptToEdit"));
            return;
        }
        ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
        Script selScript = tm.getScripts()[this.m_dlg.tblScriptList.getSelectedRow()];
        ScriptPropertiesController propsCtrl = new ScriptPropertiesController(this.m_ownerFrame, selScript, this.m_admin.getPlugin());
        propsCtrl.setScriptPropsListener(new ScriptPropsAdapter(){

            @Override
            public void scriptEdited(Script editedSript) {
                ScriptListController.this.onScriptEdited();
            }
        });
    }

    private void onScriptEdited() {
        ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
        tm.refresh();
        this.saveScriptProps();
    }

    private void saveScriptProps() {
        try {
            ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
            ClassPathEntry[] extraClassPath = new ClassPathEntry[this.m_dlg.lstExtraClasspath.getModel().getSize()];
            for (int i = 0; i < extraClassPath.length; ++i) {
                extraClassPath[i] = new ClassPathEntry((String)this.m_dlg.lstExtraClasspath.getModel().getElementAt(i));
            }
            this.m_admin.writeScriptProps(new ScriptProps(tm.getScripts(), extraClassPath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void onAdd() {
        ScriptPropertiesController propsCtrl = new ScriptPropertiesController(this.m_ownerFrame, this.m_admin.getPlugin());
        propsCtrl.setScriptPropsListener(new ScriptPropsAdapter(){

            @Override
            public void newScript(Script newScript) {
                ScriptListController.this.onNewScript(newScript);
            }
        });
    }

    private void onNewScript(Script newScript) {
        ScriptListTableModel tm = (ScriptListTableModel)this.m_dlg.tblScriptList.getModel();
        tm.addScript(newScript);
        this.saveScriptProps();
    }

    public File getScriptPropertiesFile() {
        try {
            return new File(this.m_admin.getPlugin().getPluginUserSettingsFolder().getPath() + File.separator + "UserScriptProperties.xml");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

