/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereClauseOperator;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.WhereConditionColumnWrapper;

public class WhereTreeSync {
    public void sync(DefaultMutableTreeNode root, ArrayList<WhereConditionColumnWrapper> newCols) {
        ArrayList<WhereConditionColumnWrapper> curCols = this.getAllChildCols(root);
        for (WhereConditionColumnWrapper newCol : newCols) {
            if (curCols.contains(newCol)) continue;
            root.add(new DefaultMutableTreeNode(newCol));
        }
        for (WhereConditionColumnWrapper curCol : curCols) {
            if (newCols.contains(curCol)) continue;
            this.remove(root, curCol);
        }
    }

    private boolean remove(DefaultMutableTreeNode node, WhereConditionColumnWrapper curCol) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.getUserObject().equals(curCol)) {
                node.remove(i);
                return true;
            }
            if (!this.remove(child, curCol)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<WhereConditionColumnWrapper> getAllChildCols(DefaultMutableTreeNode node) {
        ArrayList<WhereConditionColumnWrapper> ret = new ArrayList<WhereConditionColumnWrapper>();
        if (node.getUserObject() instanceof WhereClauseOperator) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                ret.addAll(this.getAllChildCols((DefaultMutableTreeNode)node.getChildAt(i)));
            }
        } else {
            ret.add((WhereConditionColumnWrapper)node.getUserObject());
        }
        return ret;
    }

    public void removeFolder(DefaultMutableTreeNode node) {
        ArrayList<WhereConditionColumnWrapper> allChildCols = this.getAllChildCols(node);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        parent.remove(node);
        for (WhereConditionColumnWrapper col : allChildCols) {
            parent.add(new DefaultMutableTreeNode(col));
        }
    }
}

