/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortProviderImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSettings;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.chooser.UIFileChooser;
import org.herac.tuxguitar.ui.chooser.UIFileChooserHandler;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIScale;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UITabFolder;
import org.herac.tuxguitar.ui.widget.UITabItem;
import org.herac.tuxguitar.ui.widget.UITable;
import org.herac.tuxguitar.ui.widget.UITableItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class MidiOutputPortSettings
extends MidiSettings {
    public MidiOutputPortSettings(MidiOutputPortProviderImpl provider) {
        super(provider);
    }

    public void configure(UIWindow uiParent) {
        final UIFactory uiFactory = TGApplication.getInstance((TGContext)this.getProvider().getContext()).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"fluidsynth.settings"));
        UITabFolder tabs = uiFactory.createTabFolder((UIContainer)dialog, false);
        dialogLayout.set((UIControl)tabs, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(450.0f), Float.valueOf(250.0f), null);
        UITabItem tSoundfonts = tabs.createTab();
        tSoundfonts.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.soundfonts"));
        UITableLayout cSoundfontsLayout = new UITableLayout();
        UIPanel cSoundfonts = uiFactory.createPanel((UIContainer)tSoundfonts, false);
        cSoundfonts.setLayout((UILayout)cSoundfontsLayout);
        final UITable soundfontsTable = uiFactory.createTable((UIContainer)cSoundfonts, true);
        cSoundfontsLayout.set((UIControl)soundfontsTable, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        cSoundfontsLayout.set((UIControl)soundfontsTable, "packed_width", (Object)Float.valueOf(0.0f));
        cSoundfontsLayout.set((UIControl)soundfontsTable, "packed_height", (Object)Float.valueOf(0.0f));
        soundfontsTable.setColumns(1);
        soundfontsTable.setColumnName(0, TuxGuitar.getProperty((String)"fluidsynth.settings.soundfonts.list"));
        UITableLayout cSoundfontsButtonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel cSoundfontsButtons = uiFactory.createPanel((UIContainer)cSoundfonts, false);
        cSoundfontsButtons.setLayout((UILayout)cSoundfontsButtonsLayout);
        cSoundfontsLayout.set((UIControl)cSoundfontsButtons, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true));
        UIButton buttonAdd = uiFactory.createButton((UIContainer)cSoundfontsButtons);
        buttonAdd.setText(TuxGuitar.getProperty((String)"add"));
        buttonAdd.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                UIFileChooser uiFileChooser = uiFactory.createOpenFileChooser(dialog);
                uiFileChooser.choose(new UIFileChooserHandler(){

                    public void onSelectFile(File file) {
                        if (file != null) {
                            MidiOutputPortSettings.this.addMidiPort((UITable<String>)soundfontsTable, file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        cSoundfontsButtonsLayout.set((UIControl)buttonAdd, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        cSoundfontsButtonsLayout.set((UIControl)buttonAdd, "margin_top", (Object)Float.valueOf(0.0f));
        cSoundfontsButtonsLayout.set((UIControl)buttonAdd, "margin_right", (Object)Float.valueOf(0.0f));
        UIButton buttonDelete = uiFactory.createButton((UIContainer)cSoundfontsButtons);
        buttonDelete.setText(TuxGuitar.getProperty((String)"remove"));
        buttonDelete.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                MidiOutputPortSettings.this.removeMidiPort((UITable<String>)soundfontsTable);
            }
        });
        cSoundfontsButtonsLayout.set((UIControl)buttonDelete, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        cSoundfontsButtonsLayout.set((UIControl)buttonDelete, "margin_bottom", (Object)Float.valueOf(0.0f));
        cSoundfontsButtonsLayout.set((UIControl)buttonDelete, "margin_right", (Object)Float.valueOf(0.0f));
        this.addMidiPorts((UITable<String>)soundfontsTable);
        UITabItem tAudio = tabs.createTab();
        tAudio.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio"));
        UITableLayout cAudioLayout = new UITableLayout();
        UIPanel cAudio = uiFactory.createPanel((UIContainer)tAudio, false);
        cAudio.setLayout((UILayout)cAudioLayout);
        List<String> audioDriverOptions = this.getAudioDriverOptions();
        UILabel lAudioDriver = uiFactory.createLabel((UIContainer)cAudio);
        lAudioDriver.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.driver"));
        cAudioLayout.set((UIControl)lAudioDriver, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect cAudioDriver = uiFactory.createDropDownSelect((UIContainer)cAudio);
        cAudioLayout.set((UIControl)cAudioDriver, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillAudioDriverCombo(audioDriverOptions, (UIDropDownSelect<String>)cAudioDriver);
        List<String> audioSampleFormatOptions = this.getAudioSampleFormatOptions();
        UILabel lAudioSampleFormat = uiFactory.createLabel((UIContainer)cAudio);
        lAudioSampleFormat.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.sample-format"));
        cAudioLayout.set((UIControl)lAudioSampleFormat, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect cAudioSampleFormat = uiFactory.createDropDownSelect((UIContainer)cAudio);
        cAudioLayout.set((UIControl)cAudioSampleFormat, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillAudioSampleFormatCombo(audioSampleFormatOptions, (UIDropDownSelect<String>)cAudioSampleFormat);
        List<Integer> audioPeriodSizeOptions = this.getAudioPeriodSizeOptions();
        UILabel lAudioPeriodSize = uiFactory.createLabel((UIContainer)cAudio);
        lAudioPeriodSize.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.period-size"));
        cAudioLayout.set((UIControl)lAudioPeriodSize, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect cAudioPeriodSize = uiFactory.createDropDownSelect((UIContainer)cAudio);
        cAudioLayout.set((UIControl)cAudioPeriodSize, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillAudioPeriodSizeCombo(audioPeriodSizeOptions, (UIDropDownSelect<Integer>)cAudioPeriodSize);
        List<Integer> audioPeriodCountOptions = this.getAudioPeriodCountOptions();
        UILabel lAudioPeriodCount = uiFactory.createLabel((UIContainer)cAudio);
        lAudioPeriodCount.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.audio.periods"));
        cAudioLayout.set((UIControl)lAudioPeriodCount, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect cAudioPeriodCount = uiFactory.createDropDownSelect((UIContainer)cAudio);
        cAudioLayout.set((UIControl)cAudioPeriodCount, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillAudioPeriodCountCombo(audioPeriodCountOptions, (UIDropDownSelect<Integer>)cAudioPeriodCount);
        UITabItem tSynth = tabs.createTab();
        tSynth.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth"));
        UITableLayout cSynthLayout = new UITableLayout();
        UIPanel cSynth = uiFactory.createPanel((UIContainer)tSynth, false);
        cSynth.setLayout((UILayout)cSynthLayout);
        UILabel lSynthGain = uiFactory.createLabel((UIContainer)cSynth);
        lSynthGain.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.gain"));
        cSynthLayout.set((UIControl)lSynthGain, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIScale sSynthGain = uiFactory.createHorizontalScale((UIContainer)cSynth);
        cSynthLayout.set((UIControl)sSynthGain, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillSynthGainScale(sSynthGain);
        List<Double> synthSampleRateOptions = this.getSynthSampleRateOptions();
        UILabel lSynthSampleRate = uiFactory.createLabel((UIContainer)cSynth);
        lSynthSampleRate.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.sample-rate"));
        cSynthLayout.set((UIControl)lSynthSampleRate, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UIDropDownSelect cSynthSampleRate = uiFactory.createDropDownSelect((UIContainer)cSynth);
        cSynthLayout.set((UIControl)cSynthSampleRate, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillSynthSampleRateCombo(synthSampleRateOptions, (UIDropDownSelect<Double>)cSynthSampleRate);
        UILabel lSynthPolyphony = uiFactory.createLabel((UIContainer)cSynth);
        lSynthPolyphony.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.polyphony"));
        cSynthLayout.set((UIControl)lSynthPolyphony, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        final UISpinner sSynthPolyphony = uiFactory.createSpinner((UIContainer)cSynth);
        cSynthLayout.set((UIControl)sSynthPolyphony, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        this.fillSynthPolyphonySpinner(sSynthPolyphony);
        final UICheckBox bSynthReverbActive = uiFactory.createCheckBox((UIContainer)cSynth);
        bSynthReverbActive.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.reverb.active"));
        cSynthLayout.set((UIControl)bSynthReverbActive, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        this.fillSynthReverbActiveCheckbox(bSynthReverbActive);
        final UICheckBox bSynthChorusActive = uiFactory.createCheckBox((UIContainer)cSynth);
        bSynthChorusActive.setText(TuxGuitar.getProperty((String)"fluidsynth.settings.synth.chorus.active"));
        cSynthLayout.set((UIControl)bSynthChorusActive, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
        this.fillSynthChorusActiveCheckbox(bSynthChorusActive);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                MidiOutputPortSettings.this.updateSoundfontsSelection((UITable<String>)soundfontsTable);
                MidiOutputPortSettings.this.updateAudioDriverSelection((String)cAudioDriver.getSelectedValue());
                MidiOutputPortSettings.this.updateAudioSampleFormatSelection((String)cAudioSampleFormat.getSelectedValue());
                MidiOutputPortSettings.this.updateAudioPeriodSizeSelection((Integer)cAudioPeriodSize.getSelectedValue());
                MidiOutputPortSettings.this.updateAudioPeriodCountSelection((Integer)cAudioPeriodCount.getSelectedValue());
                MidiOutputPortSettings.this.updateSynthSampleRateSelection((Double)cSynthSampleRate.getSelectedValue());
                MidiOutputPortSettings.this.updateSynthGainSelection(sSynthGain.getValue());
                MidiOutputPortSettings.this.updateSynthPolyphonySelection(sSynthPolyphony.getValue());
                MidiOutputPortSettings.this.updateSynthReverbActiveSelection(bSynthReverbActive.isSelected());
                MidiOutputPortSettings.this.updateSynthChorusActiveSelection(bSynthChorusActive.isSelected());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MidiOutputPortSettings.this.update();
                    }
                }).start();
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    protected void addMidiPorts(UITable<String> table) {
        for (String path : this.getSoundfonts()) {
            this.addMidiPort(table, path);
        }
    }

    protected void addMidiPort(UITable<String> table, String path) {
        UITableItem uiTableItem = new UITableItem((Object)path);
        uiTableItem.setText(0, path);
        table.addItem(uiTableItem);
    }

    protected void removeMidiPort(UITable<String> table) {
        UITableItem uiTableItem = table.getSelectedItem();
        if (uiTableItem != null) {
            table.removeItem(uiTableItem);
        }
    }

    protected List<String> getAudioDriverOptions() {
        return this.getSynth().getPropertyOptions("audio.driver");
    }

    protected List<String> getAudioSampleFormatOptions() {
        return this.getSynth().getPropertyOptions("audio.sample-format");
    }

    protected List<Integer> getAudioPeriodSizeOptions() {
        ArrayList<Integer> options = new ArrayList<Integer>();
        int[] range = this.getSynth().getIntegerPropertyRange("audio.period-size");
        if (range.length == 2 && range[0] < range[1]) {
            for (int value = range[0]; value <= range[1]; value *= 2) {
                options.add(new Integer(value));
            }
        }
        return options;
    }

    protected List<Integer> getAudioPeriodCountOptions() {
        ArrayList<Integer> options = new ArrayList<Integer>();
        int[] range = this.getSynth().getIntegerPropertyRange("audio.periods");
        if (range.length == 2 && range[0] < range[1]) {
            for (int value = range[0]; value <= range[1]; value *= 2) {
                options.add(new Integer(value));
            }
        }
        return options;
    }

    protected List<Double> getSynthSampleRateOptions() {
        ArrayList<Double> options = new ArrayList<Double>();
        double[] range = this.getSynth().getDoublePropertyRange("synth.sample-rate");
        double[] values = new double[]{22050.0, 44100.0, 48000.0, 88200.0, 96000.0};
        if (range.length == 2 && range[0] < range[1]) {
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] >= range[0]) || !(values[i] <= range[1])) continue;
                options.add(new Double(values[i]));
            }
        }
        return options;
    }

    protected void fillAudioDriverCombo(List<String> options, UIDropDownSelect<String> combo) {
        String selectedValue = this.getStringValue("audio.driver");
        for (String option : options) {
            combo.addItem(new UISelectItem(option, (Object)option));
        }
        combo.setSelectedValue((Object)selectedValue);
    }

    protected void fillAudioSampleFormatCombo(List<String> options, UIDropDownSelect<String> combo) {
        String selectedValue = this.getStringValue("audio.sample-format");
        for (String option : options) {
            combo.addItem(new UISelectItem(option, (Object)option));
        }
        combo.setSelectedValue((Object)selectedValue);
    }

    protected void fillAudioPeriodSizeCombo(List<Integer> options, UIDropDownSelect<Integer> combo) {
        int selectedValue = this.getIntegerValue("audio.period-size");
        for (Integer option : options) {
            combo.addItem(new UISelectItem(option.toString(), (Object)option));
        }
        combo.setSelectedValue((Object)selectedValue);
    }

    protected void fillAudioPeriodCountCombo(List<Integer> options, UIDropDownSelect<Integer> combo) {
        int selectedValue = this.getIntegerValue("audio.periods");
        for (Integer option : options) {
            combo.addItem(new UISelectItem(option.toString(), (Object)option));
        }
        combo.setSelectedValue((Object)selectedValue);
    }

    protected void fillSynthGainScale(UIScale scale) {
        double[] range = this.getSynth().getDoublePropertyRange("synth.gain");
        if (range.length == 2) {
            int maximum;
            int value = (int)Math.round(this.getDoubleValue("synth.gain") * 10.0);
            int minimum = (int)Math.round(range[0] * 10.0);
            if (minimum < (maximum = (int)Math.round(range[1] * 10.0))) {
                scale.setMinimum(minimum);
                scale.setMaximum(maximum);
                scale.setIncrement(1);
                if (value >= minimum && value <= maximum) {
                    scale.setValue(value);
                }
            }
        }
    }

    protected void fillSynthSampleRateCombo(List<Double> options, UIDropDownSelect<Double> combo) {
        Double selectedValue = this.getDoubleValue("synth.sample-rate");
        for (Double option : options) {
            combo.addItem(new UISelectItem(option.toString(), (Object)option));
        }
        combo.setSelectedValue((Object)selectedValue);
    }

    protected void fillSynthPolyphonySpinner(UISpinner spinner) {
        int value = this.getIntegerValue("synth.polyphony");
        int[] range = this.getSynth().getIntegerPropertyRange("synth.polyphony");
        if (range.length == 2 && range[0] < range[1]) {
            spinner.setMinimum(range[0]);
            spinner.setMaximum(range[1]);
            spinner.setIncrement(1);
            if (value >= range[0] && value <= range[1]) {
                spinner.setValue(value);
            }
        }
    }

    protected void fillSynthReverbActiveCheckbox(UICheckBox button) {
        button.setSelected(this.getBooleanValue("synth.reverb.active"));
    }

    protected void fillSynthChorusActiveCheckbox(UICheckBox button) {
        button.setSelected(this.getBooleanValue("synth.chorus.active"));
    }

    protected void updateAudioDriverSelection(String value) {
        if (value != null) {
            this.setStringValue("audio.driver", value);
        }
    }

    protected void updateAudioSampleFormatSelection(String value) {
        if (value != null) {
            this.setStringValue("audio.sample-format", value);
        }
    }

    protected void updateAudioPeriodSizeSelection(Integer value) {
        if (value != null) {
            this.setIntegerValue("audio.period-size", value);
        }
    }

    protected void updateAudioPeriodCountSelection(Integer value) {
        if (value != null) {
            this.setIntegerValue("audio.periods", value);
        }
    }

    protected void updateSynthGainSelection(int value) {
        int maximum;
        int minimum;
        double doubleValue = (double)value / 10.0;
        double[] range = this.getSynth().getDoublePropertyRange("synth.gain");
        if (range.length == 2 && (minimum = (int)Math.round(range[0])) < (maximum = (int)Math.round(range[1])) && doubleValue >= (double)minimum && doubleValue <= (double)maximum) {
            this.setDoubleValue("synth.gain", doubleValue);
        }
    }

    protected void updateSynthSampleRateSelection(Double value) {
        if (value != null) {
            this.setDoubleValue("synth.sample-rate", value);
        }
    }

    protected void updateSynthPolyphonySelection(int value) {
        int[] range = this.getSynth().getIntegerPropertyRange("synth.polyphony");
        if (range.length == 2 && range[0] < range[1] && value >= range[0] && value <= range[1] && value >= range[0] && value <= range[1]) {
            this.setIntegerValue("synth.polyphony", value);
        }
    }

    protected void updateSynthReverbActiveSelection(boolean value) {
        this.setBooleanValue("synth.reverb.active", value);
    }

    protected void updateSynthChorusActiveSelection(boolean value) {
        this.setBooleanValue("synth.chorus.active", value);
    }

    protected void updateSoundfontsSelection(UITable<String> table) {
        ArrayList<String> soundfonts = new ArrayList<String>();
        int count = table.getItemCount();
        for (int i = 0; i < count; ++i) {
            String soundfont = (String)table.getItemValue(i);
            if (soundfont == null) continue;
            soundfonts.add(soundfont);
        }
        this.setSoundfonts(soundfonts);
    }

    protected void update() {
        this.save();
        this.apply();
    }
}

