/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.swt.widget.SWTContainer;
import org.herac.tuxguitar.ui.swt.widget.SWTControl;
import org.herac.tuxguitar.ui.widget.UISeparator;

public class SWTSeparator
extends SWTControl<Label>
implements UISeparator {
    private int orientationStyle;
    private UIRectangle bounds;

    public SWTSeparator(SWTContainer<? extends Composite> parent, int orientationStyle) {
        super(new Label(parent.getControl(), 2 | orientationStyle), parent);
        this.orientationStyle = orientationStyle;
        this.bounds = new UIRectangle();
    }

    @Override
    public UIRectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        this.bounds.getPosition().setX(bounds.getX());
        this.bounds.getPosition().setY(bounds.getY());
        this.bounds.getSize().setWidth(bounds.getWidth());
        this.bounds.getSize().setHeight(bounds.getHeight());
        super.setBounds(this.createTargetBounds());
    }

    public UIRectangle createTargetBounds() {
        float x = this.bounds.getX();
        float y = this.bounds.getY();
        float width = this.bounds.getWidth();
        float height = this.bounds.getHeight();
        Point computedSize = ((Label)this.getControl()).computeSize(-1, -1);
        if ((this.orientationStyle & 0x200) != 0) {
            x = x + width / 2.0f - (float)(computedSize.x / 2);
            width = computedSize.x;
        } else {
            y = y + height / 2.0f - (float)(computedSize.y / 2);
            height = computedSize.y;
        }
        return new UIRectangle(x, y, width, height);
    }
}

