/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

import java.util.List;
import org.herac.tuxguitar.jack.JackClient;
import org.herac.tuxguitar.jack.sequencer.JackSequencer;

public class JackTickController {
    private static final int TRANSPORT_FRAME_WAIT_TIME = 10;
    private static final int TRANSPORT_FRAME_WAIT_COUNT = 10;
    private int tempo;
    private long frame;
    private long lastFrame;
    private long tickLength;
    private double tick;
    private Object lock = new Object();
    private JackSequencer sequencer;

    public JackTickController(JackSequencer sequencer) {
        this.sequencer = sequencer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Object object = this.lock;
        synchronized (object) {
            long frameRate = this.sequencer.getJackClient().getTransportFrameRate();
            this.lastFrame = this.frame;
            this.frame = this.sequencer.getJackClient().getTransportFrame();
            this.tick += 960.0 * ((double)this.getTempo() * (double)(this.frame - this.lastFrame) / 60.0) / (double)frameRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTick(long tick, boolean updateTransport) {
        Object object = this.lock;
        synchronized (object) {
            long frameRate = this.sequencer.getJackClient().getTransportFrameRate();
            if (updateTransport) {
                this.setTransportFrame(Math.round(this.tickToFrame(tick, frameRate)));
            }
            this.frame = this.sequencer.getJackClient().getTransportFrame();
            this.tick = this.frameToTick(this.frame, frameRate);
        }
    }

    public double getTick() {
        return this.tick;
    }

    public long getTickLength() {
        return this.tickLength;
    }

    public void clearTick() {
        this.tickLength = 0L;
    }

    public void notifyTick(long tick) {
        this.tickLength = Math.max(this.tickLength, tick);
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public int getTempo() {
        return this.tempo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTransportFrame(long frame) {
        JackClient jackClient = this.sequencer.getJackClient();
        jackClient.setTransportFrame(frame);
        try {
            Object transportFrameLock = new Object();
            int tryIndex = 0;
            int tryCount = 10;
            while (!jackClient.isTransportRunning() && jackClient.getTransportFrame() != frame && tryIndex++ < tryCount) {
                Object object = transportFrameLock;
                synchronized (object) {
                    transportFrameLock.wait(10L);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public double frameToTick(long frame, long frameRate) {
        double framePos = 0.0;
        double tempo = 120.0;
        double tick = 960.0;
        List<long[]> tempoChanges = this.sequencer.getJackEventController().getTempoChanges();
        for (int i = 0; i < tempoChanges.size(); ++i) {
            long[] tc = tempoChanges.get(i);
            double tcTick = tc[0];
            double tcValue = tc[1];
            double tickFrames = (double)frameRate * (tcTick - tick) / 960.0 * (60.0 / tempo);
            if (!(framePos + tickFrames <= (double)frame)) break;
            framePos += tickFrames;
            tempo = tcValue;
            tick = tcTick;
        }
        if ((double)frame > framePos) {
            double timeFrame = ((double)frame - framePos) / (double)frameRate * 1000.0;
            double timeTick = timeFrame * 960.0 / 1000.0;
            tick += timeTick * (tempo / 60.0);
        }
        return tick;
    }

    public double tickToFrame(long tick, long frameRate) {
        double tickPos = 960.0;
        double tempo = 120.0;
        double frame = 0.0;
        List<long[]> tempoChanges = this.sequencer.getJackEventController().getTempoChanges();
        for (int i = 0; i < tempoChanges.size(); ++i) {
            long[] tc = tempoChanges.get(i);
            double tcTick = tc[0];
            double tcValue = tc[1];
            double tickFrames = (double)frameRate * (tcTick - tickPos) / 960.0 * (60.0 / tempo);
            if (!(tcTick <= (double)tick)) break;
            frame += tickFrames;
            tempo = tcValue;
            tickPos = tcTick;
        }
        if ((double)tick > tickPos) {
            double timeTick = ((double)tick - tickPos) / 960.0 * 1000.0;
            double timeFrame = timeTick * (double)frameRate / 1000.0;
            frame += timeFrame * (60.0 / tempo);
        }
        return frame;
    }
}

