/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGMusicKeyNames;

public class TGMusicKeyUtils {
    public static final String PREFIX_CHORD = "chord";
    public static final String PREFIX_SCALE = "scale";
    public static final String PREFIX_TUNING = "tuning";
    public static final String PREFIX_FRETBOARD = "fretboard";
    public static final String PREFIX_MATRIX = "matrix";
    private static final String[][] DEFAULT_KEY_NAMES = new String[][]{{"C", "C#", "Cb"}, {"D", "D#", "Db"}, {"E", "E#", "Eb"}, {"F", "F#", "Fb"}, {"G", "G#", "Gb"}, {"A", "A#", "Ab"}, {"B", "B#", "Bb"}};

    public static String[] getSharpKeyNames(String prefix) {
        return new TGMusicKeyNames(true, prefix).getNames();
    }

    public static String[] getFlatKeyNames(String prefix) {
        return new TGMusicKeyNames(false, prefix).getNames();
    }

    protected static void loadKeyNames(String[] names, String prefix, boolean sharp) {
        if (sharp) {
            TGMusicKeyUtils.loadSharpKeyNames(names, prefix);
        } else {
            TGMusicKeyUtils.loadFlatKeyNames(names, prefix);
        }
    }

    private static void loadSharpKeyNames(String[] names, String prefix) {
        names[0] = TGMusicKeyUtils.getName(prefix, 0, 0);
        names[1] = TGMusicKeyUtils.getName(prefix, 0, 1);
        names[2] = TGMusicKeyUtils.getName(prefix, 1, 0);
        names[3] = TGMusicKeyUtils.getName(prefix, 1, 1);
        names[4] = TGMusicKeyUtils.getName(prefix, 2, 0);
        names[5] = TGMusicKeyUtils.getName(prefix, 3, 0);
        names[6] = TGMusicKeyUtils.getName(prefix, 3, 1);
        names[7] = TGMusicKeyUtils.getName(prefix, 4, 0);
        names[8] = TGMusicKeyUtils.getName(prefix, 4, 1);
        names[9] = TGMusicKeyUtils.getName(prefix, 5, 0);
        names[10] = TGMusicKeyUtils.getName(prefix, 5, 1);
        names[11] = TGMusicKeyUtils.getName(prefix, 6, 0);
    }

    private static void loadFlatKeyNames(String[] names, String prefix) {
        names[0] = TGMusicKeyUtils.getName(prefix, 0, 0);
        names[1] = TGMusicKeyUtils.getName(prefix, 1, 2);
        names[2] = TGMusicKeyUtils.getName(prefix, 1, 0);
        names[3] = TGMusicKeyUtils.getName(prefix, 2, 2);
        names[4] = TGMusicKeyUtils.getName(prefix, 2, 0);
        names[5] = TGMusicKeyUtils.getName(prefix, 3, 0);
        names[6] = TGMusicKeyUtils.getName(prefix, 4, 2);
        names[7] = TGMusicKeyUtils.getName(prefix, 4, 0);
        names[8] = TGMusicKeyUtils.getName(prefix, 5, 2);
        names[9] = TGMusicKeyUtils.getName(prefix, 5, 0);
        names[10] = TGMusicKeyUtils.getName(prefix, 6, 2);
        names[11] = TGMusicKeyUtils.getName(prefix, 6, 0);
    }

    private static String getName(String prefix, int key, int signature) {
        String resource = "key." + prefix + "." + key + "." + signature;
        return TuxGuitar.getInstance().getLanguageManager().getProperty(resource, DEFAULT_KEY_NAMES[key][signature]);
    }
}

