/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.component.table;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.table.TGTable;
import org.herac.tuxguitar.app.view.component.table.TGTableCanvasPainter;
import org.herac.tuxguitar.app.view.component.table.TGTableColorModel;
import org.herac.tuxguitar.app.view.component.table.TGTableRow;
import org.herac.tuxguitar.app.view.component.table.TGTableRowCell;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.menu.impl.TrackMenu;
import org.herac.tuxguitar.app.view.util.TGProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcess;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.graphics.control.TGMeasureImpl;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIMouseDoubleClickListener;
import org.herac.tuxguitar.ui.event.UIMouseDownListener;
import org.herac.tuxguitar.ui.event.UIMouseEvent;
import org.herac.tuxguitar.ui.event.UIMouseUpListener;
import org.herac.tuxguitar.ui.event.UIResizeEvent;
import org.herac.tuxguitar.ui.event.UIResizeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UIScrollBarPanelLayout;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIPopupMenu;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UIResource;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;
import org.herac.tuxguitar.ui.widget.UIScrollBar;
import org.herac.tuxguitar.ui.widget.UIScrollBarPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGTableViewer
implements TGEventListener {
    private TGContext context;
    private UIScrollBarPanel composite;
    private UIScrollBar hScroll;
    private UIScrollBar vScroll;
    private UIColor[] backgrounds;
    private UIColor[] foregrounds;
    private TrackMenu menu;
    private TGTable table;
    private TGProcess redrawProcess;
    private TGProcess redrawPlayModeProcess;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateMenuItemsProcess;
    private TGTableColorModel colorModel;
    private int selectedTrack;
    private int selectedMeasure;
    private int trackCount = 0;
    private boolean autoSizeEnabled;
    private boolean update;
    private boolean followScroll;
    private boolean resetTexts;
    private boolean resetColors;

    public TGTableViewer(TGContext context) {
        this.context = context;
        this.createSyncProcesses();
        this.addListeners();
    }

    public void addListeners() {
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addRedrawListener((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
        TuxGuitar.getInstance().getIconManager().addLoader(this);
    }

    public void init(UIContainer parent) {
        this.composite = this.getUIFactory().createScrollBarPanel(parent, true, true, true);
        this.addColorModel();
        this.addLayout();
        this.addTable();
        this.addHScroll();
        this.addVScroll();
        this.loadConfig();
    }

    private void addLayout() {
        this.getControl().setLayout((UILayout)new UIScrollBarPanelLayout(false, true, true, true, false, false));
    }

    private void addHScroll() {
        this.hScroll = this.getControl().getHScroll();
        this.hScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTableViewer.this.redrawProcess.process();
            }
        });
    }

    private void addVScroll() {
        this.vScroll = this.getControl().getVScroll();
        this.vScroll.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTableViewer.this.getControl().layout();
            }
        });
    }

    private void addTable() {
        UIMouseUpListener listener = this.mouseFocusListener();
        this.table = new TGTable(this.context, (UILayoutContainer)this.getControl());
        this.table.getColumnNumber().getControl().addMouseUpListener(listener);
        this.table.getColumnSoloMute().getControl().addMouseUpListener(listener);
        this.table.getColumnName().getControl().addMouseUpListener(listener);
        this.table.getColumnInstrument().getControl().addMouseUpListener(listener);
        this.table.getColumnCanvas().getControl().addMouseUpListener(listener);
        this.table.getColumnCanvas().getLabel().addMouseDoubleClickListener((UIMouseDoubleClickListener)new TGActionProcessorListener(this.context, "action.gui.open-song-info-dialog"));
        this.table.getColumnCanvas().getControl().addMouseDoubleClickListener((UIMouseDoubleClickListener)new TGActionProcessorListener(this.context, "action.gui.open-song-info-dialog"));
        this.table.getColumnCanvas().getControl().addResizeListener(new UIResizeListener(){

            public void onResize(UIResizeEvent event) {
                TGTableViewer.this.updateHScroll();
            }
        });
        this.fireUpdate(true);
        this.loadProperties();
    }

    private void addColorModel() {
        this.colorModel = new TGTableColorModel();
    }

    public void loadProperties() {
        this.table.getColumnNumber().setTitle(TuxGuitar.getProperty("track.number"));
        this.table.getColumnSoloMute().setTitle(TuxGuitar.getProperty("track.short-solo-mute"));
        this.table.getColumnName().setTitle(TuxGuitar.getProperty("track.name"));
        this.table.getColumnInstrument().setTitle(TuxGuitar.getProperty("track.instrument"));
        this.loadMenuProperties();
    }

    public void loadIcons() {
        this.loadMenuIcons();
    }

    public void fireUpdate(boolean newSong) {
        this.update = true;
        if (newSong) {
            this.trackCount = 0;
        }
    }

    public void updateItems() {
        this.resetTexts = true;
        this.followScroll = true;
    }

    public void updateHScroll() {
        int width = Math.round((float)this.getEditor().getTablature().getCaret().getTrack().countMeasures() * this.table.getRowHeight());
        int canvasWidth = Math.round(this.table.getColumnCanvas().getControl().getBounds().getWidth());
        this.hScroll.setIncrement(Math.round(this.table.getRowHeight()));
        this.hScroll.setMaximum(Math.max(width - canvasWidth, 0));
        this.hScroll.setThumb(canvasWidth);
    }

    public void updateVScroll() {
        this.vScroll.setIncrement(Math.round(this.table.getRowHeight()));
    }

    public TGContext getContext() {
        return this.context;
    }

    public TGTable getTable() {
        return this.table;
    }

    public TGTableColorModel getColorModel() {
        return this.colorModel;
    }

    public int getHScrollSelection() {
        return this.hScroll.getValue();
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context).getFactory();
    }

    public TablatureEditor getEditor() {
        return TuxGuitar.getInstance().getTablatureEditor();
    }

    private String getInstrument(TGTrack track) {
        TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
        TGChannel channel = TuxGuitar.getInstance().getSongManager().getChannel(song, track.getChannelId());
        if (channel != null) {
            return channel.getName() != null ? channel.getName() : new String();
        }
        return new String();
    }

    private String getSoloMute(TGTrack track) {
        if (track.isSolo()) {
            return TuxGuitar.getProperty("track.short-solo-mute.s");
        }
        if (track.isMute()) {
            return TuxGuitar.getProperty("track.short-solo-mute.m");
        }
        return TuxGuitar.getProperty("track.short-solo-mute.none");
    }

    private void updateTable() {
        if (this.update) {
            int i;
            this.updateTableMenu();
            TGSong song = TuxGuitar.getInstance().getDocumentManager().getSong();
            int count = song.countTracks();
            this.table.removeRowsAfter(count);
            for (i = this.table.getRowCount(); i < count; ++i) {
                this.table.createRow();
            }
            for (i = 0; i < count; ++i) {
                final TGTrack track = song.getTrack(i);
                final TGTableRow row = this.table.getRow(i);
                if (row == null) continue;
                this.updateTableRow(row.getNumber(), track, Integer.toString(track.getNumber()));
                this.updateTableRow(row.getSoloMute(), track, this.getSoloMute(track));
                this.updateTableRow(row.getName(), track, track.getName());
                this.updateTableRow(row.getInstrument(), track, this.getInstrument(track));
                row.setMouseUpListenerLabel(new UIMouseUpListener(){

                    public void onMouseUp(UIMouseEvent event) {
                        row.getPainter().setFocus();
                    }
                });
                row.setMouseDownListenerLabel(new UIMouseDownListener(){

                    public void onMouseDown(UIMouseEvent event) {
                        if (track.getNumber() != TGTableViewer.this.getEditor().getTablature().getCaret().getTrack().getNumber()) {
                            TGActionProcessor tgActionProcessor = new TGActionProcessor(TuxGuitar.getInstance().getContext(), "action.track.goto");
                            tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                            tgActionProcessor.process();
                        }
                    }
                });
                row.setMouseDoubleClickListenerLabel(new UIMouseDoubleClickListener(){

                    public void onMouseDoubleClick(UIMouseEvent event) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                TGActionProcessor tgActionProcessor = new TGActionProcessor(TGTableViewer.this.context, "action.track.goto");
                                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                                tgActionProcessor.setOnFinish(new Runnable(){

                                    @Override
                                    public void run() {
                                        new TGActionProcessor(TuxGuitar.getInstance().getContext(), "action.gui.open-track-properties-dialog").process();
                                    }
                                });
                                tgActionProcessor.process();
                            }
                        }).start();
                    }
                });
                row.setMouseUpListenerCanvas(new UIMouseUpListener(){

                    public void onMouseUp(UIMouseEvent event) {
                        row.getPainter().setFocus();
                    }
                });
                row.setMouseDownListenerCanvas(new UIMouseDownListener(){

                    public void onMouseDown(UIMouseEvent event) {
                        int index = (int)((event.getPosition().getX() + (float)TGTableViewer.this.getHScrollSelection()) / TGTableViewer.this.getTable().getRowHeight());
                        if (index >= 0 && index < track.countMeasures()) {
                            TGMeasure measure = track.getMeasure(index);
                            TGBeat beat = TuxGuitar.getInstance().getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
                            if (beat != null) {
                                TGActionProcessor tgActionProcessor = new TGActionProcessor(TGTableViewer.this.context, "action.caret.move-to");
                                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
                                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
                                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
                                tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)track.getString(1));
                                tgActionProcessor.process();
                            }
                        }
                    }
                });
                row.setPaintListenerCanvas(new TGTableCanvasPainter(this, track));
            }
            this.table.update();
            this.selectedTrack = 0;
            this.selectedMeasure = 0;
            this.updateVScroll();
            if (!this.resizeTable(count) && this.trackCount != count) {
                this.getControl().layout();
            }
            this.trackCount = count;
        }
        this.update = false;
    }

    private boolean resizeTable(int trackCount) {
        UIWindow uiWindow = TGWindow.getInstance(this.context).getWindow();
        if (!this.autoSizeEnabled) {
            Float packedHeight = (Float)uiWindow.getLayout().get((UIControl)this.getControl(), "packed_height");
            if (packedHeight == null) {
                uiWindow.getLayout().set((UIControl)this.getControl(), "packed_height", (Object)Float.valueOf(150.0f));
                uiWindow.layout();
                return true;
            }
        } else if (this.trackCount != trackCount) {
            uiWindow.getLayout().set((UIControl)this.getControl(), "packed_height", null);
            uiWindow.layout();
            return true;
        }
        return false;
    }

    private void updateTableRow(TGTableRowCell cell, TGTrack track, String label) {
        cell.setText(label);
        cell.setData(TGTrack.class.getName(), track);
        cell.setMenu((UIPopupMenu)this.menu.getMenu());
    }

    private void updateTableMenu() {
        this.disposeMenu();
        this.createTrackMenu();
    }

    private void updateMenuItems() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.update();
        }
    }

    private void loadMenuProperties() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.loadProperties();
        }
    }

    private void loadMenuIcons() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.loadIcons();
        }
    }

    private void resetTextsValues() {
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TGTableRow row = this.table.getRow(i);
            row.getNumber().setText(Integer.toString(((TGTrack)row.getNumber().getData(TGTrack.class.getName())).getNumber()));
            row.getSoloMute().setText(this.getSoloMute((TGTrack)row.getSoloMute().getData(TGTrack.class.getName())));
            row.getName().setText(((TGTrack)row.getName().getData(TGTrack.class.getName())).getName());
            row.getInstrument().setText(this.getInstrument((TGTrack)row.getInstrument().getData(TGTrack.class.getName())));
        }
    }

    private List<UIResource> resetColors() {
        if (this.resetColors || this.backgrounds == null || this.foregrounds == null) {
            this.resetColors = false;
            ArrayList<UIColor> disposableResources = new ArrayList<UIColor>();
            if (this.backgrounds != null) {
                for (UIColor uiColor : this.backgrounds) {
                    disposableResources.add(uiColor);
                }
            }
            if (this.foregrounds != null) {
                for (UIColor uiColor : this.foregrounds) {
                    disposableResources.add(uiColor);
                }
            }
            this.backgrounds = this.colorModel.createBackgrounds(this.context);
            this.foregrounds = this.colorModel.createForegrounds(this.context);
        }
        return null;
    }

    private void redrawRows(int selectedTrack) {
        List<UIResource> disposableResources = this.resetColors();
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TGTableRow row = this.table.getRow(i);
            row.getPainter().redraw();
            if (this.selectedTrack == selectedTrack) continue;
            row.setBgColor(this.backgrounds[selectedTrack - 1 == i ? 2 : i % 2]);
            row.setFgColor(this.foregrounds[selectedTrack - 1 == i ? 2 : i % 2]);
        }
        if (disposableResources != null) {
            this.disposeResources(disposableResources.toArray(new UIResource[disposableResources.size()]));
        }
    }

    public void redraw() {
        if (!this.isDisposed()) {
            this.updateTable();
            this.table.getColumnCanvas().setTitle(TuxGuitar.getInstance().getDocumentManager().getSong().getName());
            int selectedTrack = this.getEditor().getTablature().getCaret().getTrack().getNumber();
            this.redrawRows(selectedTrack);
            this.selectedTrack = selectedTrack;
            this.selectedMeasure = 0;
            this.updateHScroll();
            if (this.resetTexts) {
                this.resetTextsValues();
                this.resetTexts = false;
            }
            if (this.followScroll) {
                this.followHorizontalScroll(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
                this.followScroll = false;
            }
            this.getControl().redraw();
        }
    }

    public void redrawPlayingMode() {
        TGMeasureImpl measure;
        if (!this.isDisposed() && (measure = TuxGuitar.getInstance().getEditorCache().getPlayMeasure()) != null && measure.getTrack() != null) {
            this.updateTable();
            int selectedTrack = measure.getTrack().getNumber();
            int selectedMeasure = measure.getNumber();
            if (this.selectedTrack != selectedTrack || this.selectedMeasure != selectedMeasure) {
                this.redrawRows(selectedTrack);
                this.followHorizontalScroll(selectedMeasure);
            }
            this.selectedTrack = selectedTrack;
            this.selectedMeasure = selectedMeasure;
        }
    }

    private void followHorizontalScroll(int selectedMeasure) {
        int hScrollSelection = this.hScroll.getValue();
        int hScrollThumb = this.hScroll.getThumb();
        float measureSize = this.table.getRowHeight();
        float measurePosition = (float)selectedMeasure * measureSize - measureSize;
        if (measurePosition - (float)hScrollSelection < 0.0f) {
            this.hScroll.setValue(Math.max(Math.round(measurePosition), 0));
        } else if (measurePosition + measureSize - (float)hScrollSelection > (float)hScrollThumb) {
            this.hScroll.setValue(Math.max(Math.round(measurePosition + measureSize - (float)hScrollThumb), 0));
        }
    }

    public void loadConfig() {
        this.autoSizeEnabled = TuxGuitar.getInstance().getConfig().getBooleanValue("table.auto-size");
        this.colorModel.resetColors(this.context);
        this.resetColors = true;
        this.trackCount = 0;
    }

    public UIScrollBarPanel getControl() {
        return this.composite;
    }

    public void createTrackMenu() {
        this.menu = new TrackMenu((UIMenu)this.getUIFactory().createPopupMenu(TGWindow.getInstance(this.context).getWindow()));
        this.menu.showItems();
        this.menu.update();
    }

    public void disposeColors() {
        this.disposeResources((UIResource[])this.backgrounds);
        this.disposeResources((UIResource[])this.foregrounds);
        this.backgrounds = null;
        this.foregrounds = null;
    }

    public void disposeMenu() {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void disposeResources(UIResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            resources[i].dispose();
        }
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.getControl().dispose();
            this.disposeMenu();
            this.disposeColors();
        }
    }

    public boolean isDisposed() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    protected int getSelectedTrack() {
        return this.selectedTrack;
    }

    public void createSyncProcesses() {
        this.redrawProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.redraw();
            }
        });
        this.redrawPlayModeProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.redrawPlayingMode();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.loadProperties();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.loadIcons();
            }
        });
        this.updateMenuItemsProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGTableViewer.this.updateMenuItems();
            }
        });
    }

    private UIMouseUpListener mouseFocusListener() {
        return new UIMouseUpListener(){

            public void onMouseUp(UIMouseEvent event) {
                TGTableRow row;
                TGTable table = TGTableViewer.this.getTable();
                if (table != null && (row = table.getRow(TGTableViewer.this.getSelectedTrack() - 1)) != null) {
                    row.getPainter().setFocus();
                }
            }
        };
    }

    public void processRedrawEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("redrawMode");
        if (type == 1) {
            this.redrawProcess.process();
        } else if (type == 3) {
            this.redrawPlayModeProcess.process();
        }
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItems();
            this.updateMenuItemsProcess.process();
        } else if (type == 3) {
            this.fireUpdate(false);
        } else if (type == 4) {
            this.fireUpdate(true);
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-redraw".equals(event.getEventType())) {
            this.processRedrawEvent(event);
        } else if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        } else if ("ui-icon".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        }
    }

    public static TGTableViewer getInstance(TGContext context) {
        return (TGTableViewer)TGSingletonUtil.getInstance((TGContext)context, (String)TGTableViewer.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGTableViewer>(){

            public TGTableViewer createInstance(TGContext context) {
                return new TGTableViewer(context);
            }
        });
    }
}

