/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.song;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableSongGeneric
extends TGUndoableEditBase {
    private int doAction;
    private TGSong undoSong;
    private TGSong redoSong;

    private TGUndoableSongGeneric(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.copySongFrom(actionContext, this.getSong(), this.redoSong);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.copySongFrom(actionContext, this.getSong(), this.undoSong);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableSongGeneric startUndo(TGContext context) {
        TGUndoableSongGeneric undoable = new TGUndoableSongGeneric(context);
        undoable.doAction = 1;
        undoable.undoSong = TGUndoableSongGeneric.getSong(context).clone(new TGFactory());
        return undoable;
    }

    public TGUndoableSongGeneric endUndo() {
        this.redoSong = TGUndoableSongGeneric.getSong(this.getContext()).clone(new TGFactory());
        return this;
    }

    public void copySongFrom(TGActionContext context, TGSong song, TGSong from) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.song.copy.from");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("from", from);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

