/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableAddTrack
extends TGUndoableTrackBase {
    private int doAction;
    private TGTrack redoableTrack;

    private TGUndoableAddTrack(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.addTrack(actionContext, this.getSong(), this.redoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.removeTrack(actionContext, this.getSong(), this.redoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableAddTrack startUndo(TGContext context) {
        TGUndoableAddTrack undoable = new TGUndoableAddTrack(context);
        undoable.doAction = 1;
        return undoable;
    }

    public TGUndoableAddTrack endUndo(TGTrack track) {
        this.redoableTrack = track.clone(new TGFactory(), this.getSong());
        return this;
    }
}

