/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;

public class SoftAudioPusher
implements Runnable {
    private volatile boolean active = false;
    private SourceDataLine sourceDataLine = null;
    private Thread audiothread;
    private AudioInputStream ais;
    private byte[] buffer;

    public SoftAudioPusher(SourceDataLine sourceDataLine, AudioInputStream audioInputStream, int n) {
        this.ais = audioInputStream;
        this.buffer = new byte[n];
        this.sourceDataLine = sourceDataLine;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.audiothread = new Thread(this);
        this.audiothread.setDaemon(true);
        this.audiothread.setPriority(10);
        this.audiothread.start();
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        try {
            this.audiothread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        byte[] byArray = this.buffer;
        AudioInputStream audioInputStream = this.ais;
        SourceDataLine sourceDataLine = this.sourceDataLine;
        try {
            int n;
            while (this.active && (n = audioInputStream.read(byArray)) >= 0) {
                sourceDataLine.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            this.active = false;
        }
    }
}

