/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.midi.synth.TGProgramElement;

public class TGProgram {
    private TGProgramElement receiver = null;
    private List<TGProgramElement> outputs = new ArrayList<TGProgramElement>();

    public TGProgramElement getReceiver() {
        return this.receiver;
    }

    public void setReceiver(TGProgramElement receiver) {
        this.receiver = receiver;
    }

    public void addOutput(TGProgramElement output) {
        if (output != null) {
            this.outputs.add(output);
        }
    }

    public void removeOutput(TGProgramElement output) {
        if (output != null && this.outputs.contains(output)) {
            this.outputs.remove(output);
        }
    }

    public TGProgramElement getOutput(int index) {
        if (index >= 0 && index < this.outputs.size()) {
            return this.outputs.get(index);
        }
        return null;
    }

    public int countOutputs() {
        return this.outputs.size();
    }

    public void copyFrom(TGProgram program) {
        this.receiver = null;
        this.outputs.clear();
        if (program.getReceiver() != null) {
            this.receiver = new TGProgramElement();
            this.receiver.copyFrom(program.getReceiver());
        }
        int outputs = program.countOutputs();
        for (int i = 0; i < outputs; ++i) {
            TGProgramElement output = new TGProgramElement();
            output.copyFrom(program.getOutput(i));
            this.addOutput(output);
        }
    }
}

