/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.pdf;

import org.herac.tuxguitar.graphics.control.TGController;
import org.herac.tuxguitar.graphics.control.TGFactoryImpl;
import org.herac.tuxguitar.graphics.control.TGLayoutStyles;
import org.herac.tuxguitar.graphics.control.print.TGPrintController;
import org.herac.tuxguitar.graphics.control.print.TGPrintDocument;
import org.herac.tuxguitar.graphics.control.print.TGPrintLayout;
import org.herac.tuxguitar.graphics.control.print.TGPrintSettings;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongWriter;
import org.herac.tuxguitar.io.base.TGSongWriterHandle;
import org.herac.tuxguitar.io.pdf.PDFDocument;
import org.herac.tuxguitar.io.pdf.PDFLayoutStyles;
import org.herac.tuxguitar.io.pdf.PDFResourceFactory;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.resource.UIInset;
import org.herac.tuxguitar.ui.resource.UIResourceFactory;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.util.TGContext;

public class PDFSongWriter
implements TGSongWriter {
    public static final TGFileFormat FILE_FORMAT = new TGFileFormat("PDF", "application/pdf", new String[]{"pdf"});
    private static final int PAGE_WIDTH = 550;
    private static final int PAGE_HEIGHT = 800;
    private static final int MARGIN_TOP = 20;
    private static final int MARGIN_BOTTOM = 20;
    private static final int MARGIN_LEFT = 20;
    private static final int MARGIN_RIGHT = 20;
    private TGContext context;

    public PDFSongWriter(TGContext context) {
        this.context = context;
    }

    public TGFileFormat getFileFormat() {
        return FILE_FORMAT;
    }

    public TGPrintSettings getDefaultStyles(TGSong song) {
        TGPrintSettings styles = new TGPrintSettings();
        styles.setStyle(125);
        styles.setFromMeasure(1);
        styles.setToMeasure(song.countMeasureHeaders());
        styles.setTrackNumber(-1);
        return styles;
    }

    public void write(TGSongWriterHandle handle) throws TGFileFormatException {
        try {
            TGLayoutStyles styles;
            TGPrintSettings settings = (TGPrintSettings)handle.getContext().getAttribute(TGPrintSettings.class.getName());
            if (settings == null) {
                settings = this.getDefaultStyles(handle.getSong());
            }
            if ((styles = (TGLayoutStyles)handle.getContext().getAttribute(TGLayoutStyles.class.getName())) == null) {
                styles = new PDFLayoutStyles();
            }
            TGSongManager manager = new TGSongManager((TGFactory)new TGFactoryImpl());
            TGSong clonedSong = handle.getSong().clone(manager.getFactory());
            PDFResourceFactory factory = new PDFResourceFactory();
            TGPrintController controller = new TGPrintController(clonedSong, manager, (UIResourceFactory)factory, styles);
            UISize pageSize = new UISize(550.0f, 800.0f);
            UIInset pageMargins = new UIInset(20.0f, 20.0f, 20.0f, 20.0f);
            TGPrintLayout layout = new TGPrintLayout((TGController)controller, settings);
            layout.loadStyles(1.0f);
            layout.updateSong();
            layout.makeDocument((TGPrintDocument)new PDFDocument(this.context, pageSize, pageMargins, handle.getOutputStream()));
            controller.getResourceBuffer().disposeAllResources();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }
}

