/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.gtp.GTPFileFormatVersion;
import org.herac.tuxguitar.io.gtp.GTPFormatException;
import org.herac.tuxguitar.io.gtp.GTPInputStream;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class GP4InputStream
extends GTPInputStream {
    public static final TGFileFormat FILE_FORMAT = new TGFileFormat("Guitar Pro 4", "audio/x-gtp", new String[]{"gp4"});
    public static final GTPFileFormatVersion[] SUPPORTED_VERSIONS = new GTPFileFormatVersion[]{new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITAR PRO v4.00", 0), new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITAR PRO v4.06", 1), new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITAR PRO L4.06", 2)};
    private static final float GP_BEND_SEMITONE = 25.0f;
    private static final float GP_BEND_POSITION = 60.0f;
    private int tripletFeel;
    private int keySignature;

    public GP4InputStream(GTPSettings settings) {
        super(settings, SUPPORTED_VERSIONS);
    }

    public TGFileFormat getFileFormat() {
        return FILE_FORMAT;
    }

    @Override
    public TGSong readSong() throws TGFileFormatException {
        try {
            this.readVersion();
            TGSong song = this.getFactory().newSong();
            this.readInfo(song);
            this.tripletFeel = this.readBoolean() ? 2 : 1;
            int lyricTrack = this.readInt();
            TGLyric lyric = this.readLyrics();
            int tempoValue = this.readInt();
            this.keySignature = this.readKeySignature();
            this.skip(3);
            this.readByte();
            List<TGChannel> channels = this.readChannels();
            int measures = this.readInt();
            int tracks = this.readInt();
            this.readMeasureHeaders(song, measures);
            this.readTracks(song, tracks, channels, lyric, lyricTrack);
            this.readMeasures(song, measures, tracks, tempoValue);
            this.close();
            return song;
        }
        catch (GTPFormatException gtpFormatException) {
            throw gtpFormatException;
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void readInfo(TGSong song) throws IOException {
        song.setName(this.readStringByteSizeOfInteger());
        this.readStringByteSizeOfInteger();
        song.setArtist(this.readStringByteSizeOfInteger());
        song.setAlbum(this.readStringByteSizeOfInteger());
        song.setAuthor(this.readStringByteSizeOfInteger());
        song.setCopyright(this.readStringByteSizeOfInteger());
        song.setWriter(this.readStringByteSizeOfInteger());
        this.readStringByteSizeOfInteger();
        int comments = this.readInt();
        for (int i = 0; i < comments; ++i) {
            song.setComments(song.getComments() + this.readStringByteSizeOfInteger());
        }
    }

    private void readMeasureHeaders(TGSong song, int count) throws IOException {
        TGTimeSignature timeSignature = this.getFactory().newTimeSignature();
        for (int i = 0; i < count; ++i) {
            song.addMeasureHeader(this.readMeasureHeader(i + 1, song, timeSignature));
        }
    }

    private void readTracks(TGSong song, int count, List<TGChannel> channels, TGLyric lyric, int lyricTrack) throws IOException {
        for (int number = 1; number <= count; ++number) {
            song.addTrack(this.readTrack(song, number, channels, number == lyricTrack ? lyric : this.getFactory().newLyric()));
        }
    }

    private void readMeasures(TGSong song, int measures, int tracks, int tempoValue) throws IOException {
        TGTempo tempo = this.getFactory().newTempo();
        tempo.setValue(tempoValue);
        long start = 960L;
        for (int i = 0; i < measures; ++i) {
            TGMeasureHeader header = song.getMeasureHeader(i);
            header.setStart(start);
            for (int j = 0; j < tracks; ++j) {
                TGTrack track = song.getTrack(j);
                TGMeasure measure = this.getFactory().newMeasure(header);
                track.addMeasure(measure);
                this.readMeasure(measure, track, tempo);
            }
            header.getTempo().copyFrom(tempo);
            start += header.getLength();
        }
    }

    private TGLyric readLyrics() throws IOException {
        TGLyric lyric = this.getFactory().newLyric();
        lyric.setFrom(this.readInt());
        lyric.setLyrics(this.readStringInteger());
        for (int i = 0; i < 4; ++i) {
            this.readInt();
            this.readStringInteger();
        }
        return lyric;
    }

    private List<TGChannel> readChannels() throws IOException {
        ArrayList<TGChannel> channels = new ArrayList<TGChannel>();
        for (int i = 0; i < 64; ++i) {
            TGChannel channel = this.getFactory().newChannel();
            channel.setProgram((short)this.readInt());
            channel.setVolume(this.toChannelShort(this.readByte()));
            channel.setBalance(this.toChannelShort(this.readByte()));
            channel.setChorus(this.toChannelShort(this.readByte()));
            channel.setReverb(this.toChannelShort(this.readByte()));
            channel.setPhaser(this.toChannelShort(this.readByte()));
            channel.setTremolo(this.toChannelShort(this.readByte()));
            channel.setBank(i == 9 ? (short)128 : 0);
            if (channel.getProgram() < 0) {
                channel.setProgram((short)0);
            }
            channels.add(channel);
            this.skip(2);
        }
        return channels;
    }

    private long readBeat(long start, TGMeasure measure, TGTrack track, TGTempo tempo) throws IOException {
        int flags = this.readUnsignedByte();
        if ((flags & 0x40) != 0) {
            this.readUnsignedByte();
        }
        TGBeat beat = this.getFactory().newBeat();
        TGVoice voice = beat.getVoice(0);
        TGDuration duration = this.readDuration(flags);
        TGNoteEffect effect = this.getFactory().newEffect();
        if ((flags & 2) != 0) {
            this.readChord(track.stringCount(), beat);
        }
        if ((flags & 4) != 0) {
            this.readText(beat);
        }
        if ((flags & 8) != 0) {
            this.readBeatEffects(beat, effect);
        }
        if ((flags & 0x10) != 0) {
            this.readMixChange(tempo);
        }
        int stringFlags = this.readUnsignedByte();
        for (int i = 6; i >= 0; --i) {
            if ((stringFlags & 1 << i) == 0 || 6 - i >= track.stringCount()) continue;
            TGString string = track.getString(6 - i + 1).clone(this.getFactory());
            TGNote note = this.readNote(string, track, effect.clone(this.getFactory()));
            voice.addNote(note);
        }
        beat.setStart(start);
        voice.setEmpty(false);
        voice.getDuration().copyFrom(duration);
        measure.addBeat(beat);
        return duration.getTime();
    }

    private void readText(TGBeat beat) throws IOException {
        TGText text = this.getFactory().newText();
        text.setValue(this.readStringByteSizeOfInteger());
        beat.setText(text);
    }

    private TGDuration readDuration(int flags) throws IOException {
        TGDuration duration = this.getFactory().newDuration();
        duration.setValue((int)(Math.pow(2.0, this.readByte() + 4) / 4.0));
        duration.setDotted((flags & 1) != 0);
        if ((flags & 0x20) != 0) {
            int divisionType = this.readInt();
            switch (divisionType) {
                case 3: {
                    duration.getDivision().setEnters(3);
                    duration.getDivision().setTimes(2);
                    break;
                }
                case 5: {
                    duration.getDivision().setEnters(5);
                    duration.getDivision().setTimes(4);
                    break;
                }
                case 6: {
                    duration.getDivision().setEnters(6);
                    duration.getDivision().setTimes(4);
                    break;
                }
                case 7: {
                    duration.getDivision().setEnters(7);
                    duration.getDivision().setTimes(4);
                    break;
                }
                case 9: {
                    duration.getDivision().setEnters(9);
                    duration.getDivision().setTimes(8);
                    break;
                }
                case 10: {
                    duration.getDivision().setEnters(10);
                    duration.getDivision().setTimes(8);
                    break;
                }
                case 11: {
                    duration.getDivision().setEnters(11);
                    duration.getDivision().setTimes(8);
                    break;
                }
                case 12: {
                    duration.getDivision().setEnters(12);
                    duration.getDivision().setTimes(8);
                }
            }
        }
        return duration;
    }

    private int getTiedNoteValue(int string, TGTrack track) {
        int measureCount = track.countMeasures();
        if (measureCount > 0) {
            for (int m = measureCount - 1; m >= 0; --m) {
                TGMeasure measure = track.getMeasure(m);
                for (int b = measure.countBeats() - 1; b >= 0; --b) {
                    TGBeat beat = measure.getBeat(b);
                    TGVoice voice = beat.getVoice(0);
                    for (int n = 0; n < voice.countNotes(); ++n) {
                        TGNote note = voice.getNote(n);
                        if (note.getString() != string) continue;
                        return note.getValue();
                    }
                }
            }
        }
        return -1;
    }

    private void readColor(TGColor color) throws IOException {
        color.setR(this.readUnsignedByte());
        color.setG(this.readUnsignedByte());
        color.setB(this.readUnsignedByte());
        this.read();
    }

    private TGMarker readMarker(int measure) throws IOException {
        TGMarker marker = this.getFactory().newMarker();
        marker.setMeasure(measure);
        marker.setTitle(this.readStringByteSizeOfInteger());
        this.readColor(marker.getColor());
        return marker;
    }

    private TGMeasureHeader readMeasureHeader(int number, TGSong song, TGTimeSignature timeSignature) throws IOException {
        int flags = this.readUnsignedByte();
        TGMeasureHeader header = this.getFactory().newHeader();
        header.setNumber(number);
        header.setStart(0L);
        header.getTempo().setValue(120);
        header.setTripletFeel(this.tripletFeel);
        header.setRepeatOpen((flags & 4) != 0);
        if ((flags & 1) != 0) {
            timeSignature.setNumerator((int)this.readByte());
        }
        if ((flags & 2) != 0) {
            timeSignature.getDenominator().setValue((int)this.readByte());
        }
        header.getTimeSignature().copyFrom(timeSignature);
        if ((flags & 8) != 0) {
            header.setRepeatClose((int)this.readByte());
        }
        if ((flags & 0x10) != 0) {
            header.setRepeatAlternative(this.parseRepeatAlternative(song, number, this.readUnsignedByte()));
        }
        if ((flags & 0x20) != 0) {
            header.setMarker(this.readMarker(number));
        }
        if ((flags & 0x40) != 0) {
            this.keySignature = this.readKeySignature();
            this.skip(1);
        }
        return header;
    }

    private void readMeasure(TGMeasure measure, TGTrack track, TGTempo tempo) throws IOException {
        long nextNoteStart = measure.getStart();
        int numberOfBeats = this.readInt();
        for (int i = 0; i < numberOfBeats; ++i) {
            nextNoteStart += this.readBeat(nextNoteStart, measure, track, tempo);
        }
        measure.setClef(this.getClef(track));
        measure.setKeySignature(this.keySignature);
    }

    private TGNote readNote(TGString string, TGTrack track, TGNoteEffect effect) throws IOException {
        int flags = this.readUnsignedByte();
        TGNote note = this.getFactory().newNote();
        note.setString(string.getNumber());
        note.setEffect(effect);
        note.getEffect().setAccentuatedNote((flags & 0x40) != 0);
        note.getEffect().setGhostNote((flags & 4) != 0);
        if ((flags & 0x20) != 0) {
            int noteType = this.readUnsignedByte();
            note.setTiedNote(noteType == 2);
            note.getEffect().setDeadNote(noteType == 3);
        }
        if ((flags & 1) != 0) {
            this.skip(2);
        }
        if ((flags & 0x10) != 0) {
            note.setVelocity(15 + 16 * this.readByte() - 16);
        }
        if ((flags & 0x20) != 0) {
            int fret = this.readByte();
            int value = note.isTiedNote() ? this.getTiedNoteValue(string.getNumber(), track) : fret;
            note.setValue(value >= 0 && value < 100 ? value : 0);
        }
        if ((flags & 0x80) != 0) {
            this.skip(2);
        }
        if ((flags & 8) != 0) {
            this.readNoteEffects(note.getEffect());
        }
        return note;
    }

    private TGTrack readTrack(TGSong song, int number, List<TGChannel> channels, TGLyric lyrics) throws IOException {
        TGTrack track = this.getFactory().newTrack();
        track.setNumber(number);
        track.setLyrics(lyrics);
        this.readUnsignedByte();
        track.setName(this.readStringByte(40));
        int stringCount = this.readInt();
        for (int i = 0; i < 7; ++i) {
            int tuning = this.readInt();
            if (stringCount <= i) continue;
            TGString string = this.getFactory().newString();
            string.setNumber(i + 1);
            string.setValue(tuning);
            track.getStrings().add(string);
        }
        this.readInt();
        this.readChannel(song, track, channels);
        this.readInt();
        track.setOffset(this.readInt());
        this.readColor(track.getColor());
        return track;
    }

    private void readChannel(TGSong song, TGTrack track, List<TGChannel> channels) throws IOException {
        int gmChannel1 = this.readInt() - 1;
        int gmChannel2 = this.readInt() - 1;
        if (gmChannel1 >= 0 && gmChannel1 < channels.size()) {
            TGChannel channel = this.getFactory().newChannel();
            TGChannelParameter gmChannel1Param = this.getFactory().newChannelParameter();
            TGChannelParameter gmChannel2Param = this.getFactory().newChannelParameter();
            gmChannel1Param.setKey("gm-channel-1");
            gmChannel1Param.setValue(Integer.toString(gmChannel1));
            gmChannel2Param.setKey("gm-channel-2");
            gmChannel2Param.setValue(Integer.toString(gmChannel1 != 9 ? gmChannel2 : gmChannel1));
            channel.copyFrom(this.getFactory(), channels.get(gmChannel1));
            for (int i = 0; i < song.countChannels(); ++i) {
                TGChannel channelAux = song.getChannel(i);
                for (int n = 0; n < channelAux.countParameters(); ++n) {
                    TGChannelParameter channelParameter = channelAux.getParameter(n);
                    if (!channelParameter.getKey().equals("gm-channel-1") || !Integer.toString(gmChannel1).equals(channelParameter.getValue())) continue;
                    channel.setChannelId(channelAux.getChannelId());
                }
            }
            if (channel.getChannelId() <= 0) {
                channel.setChannelId(song.countChannels() + 1);
                channel.setName(new TGSongManager(this.getFactory()).createChannelNameFromProgram(song, channel));
                channel.addParameter(gmChannel1Param);
                channel.addParameter(gmChannel2Param);
                song.addChannel(channel);
            }
            track.setChannelId(channel.getChannelId());
        }
    }

    private int parseRepeatAlternative(TGSong song, int measure, int value) {
        TGMeasureHeader header;
        int repeatAlternative = 0;
        int existentAlternatives = 0;
        Iterator it = song.getMeasureHeaders();
        while (it.hasNext() && (header = (TGMeasureHeader)it.next()).getNumber() != measure) {
            if (header.isRepeatOpen()) {
                existentAlternatives = 0;
            }
            existentAlternatives |= header.getRepeatAlternative();
        }
        for (int i = 0; i < 8; ++i) {
            if (value <= i || (existentAlternatives & 1 << i) != 0) continue;
            repeatAlternative |= 1 << i;
        }
        return repeatAlternative;
    }

    private void readChord(int strings, TGBeat beat) throws IOException {
        TGChord chord = this.getFactory().newChord(strings);
        if ((this.readUnsignedByte() & 1) == 0) {
            chord.setName(this.readStringByteSizeOfInteger());
            chord.setFirstFret(this.readInt());
            if (chord.getFirstFret() != 0) {
                for (int i = 0; i < 6; ++i) {
                    int fret = this.readInt();
                    if (i >= chord.countStrings()) continue;
                    chord.addFretValue(i, fret);
                }
            }
        } else {
            this.skip(16);
            chord.setName(this.readStringByte(21));
            this.skip(4);
            chord.setFirstFret(this.readInt());
            for (int i = 0; i < 7; ++i) {
                int fret = this.readInt();
                if (i >= chord.countStrings()) continue;
                chord.addFretValue(i, fret);
            }
            this.skip(32);
        }
        if (chord.countNotes() > 0) {
            beat.setChord(chord);
        }
    }

    private void readGrace(TGNoteEffect effect) throws IOException {
        int fret = this.readUnsignedByte();
        TGEffectGrace grace = this.getFactory().newEffectGrace();
        grace.setOnBeat(false);
        grace.setDead(fret == 255);
        grace.setFret(!grace.isDead() ? fret : 0);
        grace.setDynamic(15 + 16 * this.readUnsignedByte() - 16);
        int transition = this.readUnsignedByte();
        if (transition == 0) {
            grace.setTransition(0);
        } else if (transition == 1) {
            grace.setTransition(1);
        } else if (transition == 2) {
            grace.setTransition(2);
        } else if (transition == 3) {
            grace.setTransition(3);
        }
        grace.setDuration(this.readUnsignedByte());
        effect.setGrace(grace);
    }

    private void readBend(TGNoteEffect effect) throws IOException {
        TGEffectBend bend = this.getFactory().newEffectBend();
        this.skip(5);
        int points = this.readInt();
        for (int i = 0; i < points; ++i) {
            int position = this.readInt();
            int value = this.readInt();
            this.readByte();
            int pointPosition = Math.round((float)(position * 12) / 60.0f);
            int pointValue = Math.round((float)(value * 1) / 25.0f);
            bend.addPoint(pointPosition, pointValue);
        }
        if (!bend.getPoints().isEmpty()) {
            effect.setBend(bend);
        }
    }

    private void readTremoloBar(TGNoteEffect effect) throws IOException {
        TGEffectTremoloBar tremoloBar = this.getFactory().newEffectTremoloBar();
        this.skip(5);
        int points = this.readInt();
        for (int i = 0; i < points; ++i) {
            int position = this.readInt();
            int value = this.readInt();
            this.readByte();
            int pointPosition = Math.round((float)(position * 12) / 60.0f);
            int pointValue = Math.round((float)value / 50.0f);
            tremoloBar.addPoint(pointPosition, pointValue);
        }
        if (!tremoloBar.getPoints().isEmpty()) {
            effect.setTremoloBar(tremoloBar);
        }
    }

    public void readTremoloPicking(TGNoteEffect effect) throws IOException {
        int value = this.readUnsignedByte();
        TGEffectTremoloPicking tp = this.getFactory().newEffectTremoloPicking();
        if (value == 1) {
            tp.getDuration().setValue(8);
            effect.setTremoloPicking(tp);
        } else if (value == 2) {
            tp.getDuration().setValue(16);
            effect.setTremoloPicking(tp);
        } else if (value == 3) {
            tp.getDuration().setValue(32);
            effect.setTremoloPicking(tp);
        }
    }

    private void readNoteEffects(TGNoteEffect noteEffect) throws IOException {
        int flags1 = this.readUnsignedByte();
        int flags2 = this.readUnsignedByte();
        noteEffect.setHammer((flags1 & 2) != 0);
        noteEffect.setLetRing((flags1 & 8) != 0);
        noteEffect.setVibrato((flags2 & 0x40) != 0 || noteEffect.isVibrato());
        noteEffect.setPalmMute((flags2 & 2) != 0);
        noteEffect.setStaccato((flags2 & 1) != 0);
        if ((flags1 & 1) != 0) {
            this.readBend(noteEffect);
        }
        if ((flags1 & 0x10) != 0) {
            this.readGrace(noteEffect);
        }
        if ((flags2 & 4) != 0) {
            this.readTremoloPicking(noteEffect);
        }
        if ((flags2 & 8) != 0) {
            noteEffect.setSlide(true);
            this.readByte();
        }
        if ((flags2 & 0x10) != 0) {
            TGEffectHarmonic harmonic = this.getFactory().newEffectHarmonic();
            byte type = this.readByte();
            if (type == 1) {
                harmonic.setType(1);
            } else if (type == 3) {
                harmonic.setType(3);
            } else if (type == 4) {
                harmonic.setType(4);
            } else if (type == 5) {
                harmonic.setType(5);
            } else if (type == 15) {
                harmonic.setType(2);
                harmonic.setData(2);
            } else if (type == 17) {
                harmonic.setType(2);
                harmonic.setData(3);
            } else if (type == 22) {
                harmonic.setType(2);
                harmonic.setData(0);
            }
            noteEffect.setHarmonic(harmonic);
        }
        if ((flags2 & 0x20) != 0) {
            byte fret = this.readByte();
            byte period = this.readByte();
            TGEffectTrill trill = this.getFactory().newEffectTrill();
            trill.setFret((int)fret);
            if (period == 1) {
                trill.getDuration().setValue(16);
                noteEffect.setTrill(trill);
            } else if (period == 2) {
                trill.getDuration().setValue(32);
                noteEffect.setTrill(trill);
            } else if (period == 3) {
                trill.getDuration().setValue(64);
                noteEffect.setTrill(trill);
            }
        }
    }

    private void readBeatEffects(TGBeat beat, TGNoteEffect noteEffect) throws IOException {
        int flags1 = this.readUnsignedByte();
        int flags2 = this.readUnsignedByte();
        noteEffect.setFadeIn((flags1 & 0x10) != 0);
        noteEffect.setVibrato((flags1 & 2) != 0);
        if ((flags1 & 0x20) != 0) {
            int effect = this.readUnsignedByte();
            noteEffect.setTapping(effect == 1);
            noteEffect.setSlapping(effect == 2);
            noteEffect.setPopping(effect == 3);
        }
        if ((flags2 & 4) != 0) {
            this.readTremoloBar(noteEffect);
        }
        if ((flags1 & 0x40) != 0) {
            byte strokeDown = this.readByte();
            byte strokeUp = this.readByte();
            if (strokeDown > 0) {
                beat.getStroke().setDirection(-1);
                beat.getStroke().setValue(this.toStrokeValue(strokeDown));
            } else if (strokeUp > 0) {
                beat.getStroke().setDirection(1);
                beat.getStroke().setValue(this.toStrokeValue(strokeUp));
            }
        }
        if ((flags2 & 2) != 0) {
            this.readByte();
        }
    }

    private void readMixChange(TGTempo tempo) throws IOException {
        this.readByte();
        byte volume = this.readByte();
        byte pan = this.readByte();
        byte chorus = this.readByte();
        byte reverb = this.readByte();
        byte phaser = this.readByte();
        byte tremolo = this.readByte();
        int tempoValue = this.readInt();
        if (volume >= 0) {
            this.readByte();
        }
        if (pan >= 0) {
            this.readByte();
        }
        if (chorus >= 0) {
            this.readByte();
        }
        if (reverb >= 0) {
            this.readByte();
        }
        if (phaser >= 0) {
            this.readByte();
        }
        if (tremolo >= 0) {
            this.readByte();
        }
        if (tempoValue >= 0) {
            tempo.setValue(tempoValue);
            this.readByte();
        }
        this.readByte();
    }

    private int readKeySignature() throws IOException {
        int keySignature = this.readByte();
        if (keySignature < 0) {
            keySignature = 7 - keySignature;
        }
        return keySignature;
    }

    private int toStrokeValue(int value) {
        if (value == 1 || value == 2) {
            return 64;
        }
        if (value == 3) {
            return 32;
        }
        if (value == 4) {
            return 16;
        }
        if (value == 5) {
            return 8;
        }
        if (value == 6) {
            return 4;
        }
        return 64;
    }

    private short toChannelShort(byte b) {
        short value = (short)(b * 8 - 1);
        return (short)Math.max(value, 0);
    }

    private int getClef(TGTrack track) {
        if (!this.isPercussionChannel(track.getSong(), track.getChannelId())) {
            for (TGString string : track.getStrings()) {
                if (string.getValue() > 34) continue;
                return 2;
            }
        }
        return 1;
    }

    private boolean isPercussionChannel(TGSong song, int channelId) {
        Iterator it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = (TGChannel)it.next();
            if (channel.getChannelId() != channelId) continue;
            return channel.isPercussionChannel();
        }
        return false;
    }
}

