/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gpx.v6;

public class GPXByteBuffer {
    private static final int BUFFER_TYPE_BITS = 8;
    private int position;
    private byte[] buffer;

    public GPXByteBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.position = 0;
    }

    public int length() {
        return this.buffer.length;
    }

    public int offset() {
        return this.position / 8;
    }

    public boolean end() {
        return this.offset() >= this.length();
    }

    public int readBit() {
        int bit = -1;
        int byteIndex = this.position / 8;
        int byteOffset = 7 - this.position % 8;
        if (byteIndex >= 0 && byteIndex < this.buffer.length) {
            bit = (this.buffer[byteIndex] & 0xFF) >> byteOffset & 1;
            ++this.position;
        }
        return bit;
    }

    public int readBits(int count) {
        int bits = 0;
        for (int i = count - 1; i >= 0; --i) {
            bits |= this.readBit() << i;
        }
        return bits;
    }

    public int readBitsReversed(int count) {
        int bits = 0;
        for (int i = 0; i < count; ++i) {
            bits |= this.readBit() << i;
        }
        return bits;
    }

    public byte[] readBytes(int count) {
        byte[] bytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            bytes[i] = (byte)this.readBits(8);
        }
        return bytes;
    }
}

