/*
	This implementation of splay trees came from 
	Cedric Verstraeten (thank you Cedric)

	...although I had read about them in 1985 in:
--
-- Journal of the A.C.M., July 1985,
-- Vol. 32, No. 3, pg. 652, library call # QA 76 A77
--
	and was amazed at their properties.
*/



#ifndef __BINSEARCHTREE
#define __BINSEARCHTREE
#include <cstdlib>
#include <iostream>
#include <queue>
using std::ostream;
using std::max;
/**********************************************************************
   Klasse: BinTree met BinNode: binaire boom
   
   beschrijving: Domme klasse om de gegevens van een boom te bevatten
                 Omdat ze enkel in een wrapper wordt gebruikt, heeft ze
                 alles publiek staan. Ze mag dan ook nooit buiten een
                 wrapper gebruikt worden!
   
***************************************************************************/

template <class Key,class Data>
class BinNode;

template <class Key,class Data>
class BinTree{
public:
    BinTree<Key,Data>():k(0){}
    ~BinTree<Key,Data>(){
        delete k;
    }
    
	int depth() const{
        if (k==0)
            return 0;
        else
            return max(k->left.depth(),k->right.depth())+1;
    };

/*
    void write(ostream&) const;
    void write(ostream& os,BinNode<Key,Data>* kn) const{
        if (kn!=0)
            os<<"("<<kn->key<<","<<kn->data<<")";
        else
            os<<"(,)";
    }
*/

    void roteer(bool left);
//pointer naar wortelknoop
     BinNode<Key,Data>* k;

};



template <class Key,class Data>
class BinNode{
    public:
        Key key;
        Data data;
        BinNode<Key,Data>* parent;
        BinTree<Key,Data> left,right;
        BinNode():parent(0){}
        BinNode(const Key& _key,const Data& _data):parent(0),key(_key),data(_data){}
};

/**********************************************************************
   klasse: BinSearchTree
   
   beschrijving: Dit is een wrapper voor een BinTree,
                 die ervoor zorgt dat de keyeutels in de BinTree
                 op volgorde staan
   
***************************************************************************/

template <class Key,class Data>
class BinSearchTree{
public:
     virtual void insert(const Key&,const Data&);
//volgende functie doet niets als er geen knoop is met het gegeven Key
     virtual void remove(const Key&);
//geef pointer naar data horend bij een keyeutel
     virtual Data* ptr2data(const Key&);
     int depth() const{return deBinTree.depth();};


protected:
//searchPosition: geeft adres van boom waaraan knoop hangt, of zou moeten hangen
//en adres van de parent.
     virtual void searchPosition(const Key&,BinTree<Key,Data>*&,BinNode<Key,Data>*&);
//De binaire boom die de data bevat
     BinTree<Key,Data> deBinTree;
//geeft de predecessor. Verunderstelt dat de linkerboom under de knoop niet leeg is
     BinTree<Key,Data>* underpredecessor(BinNode<Key,Data>*);
};

template <class Key,class Data>
void BinTree<Key,Data>::roteer(bool left){
    BinNode<Key,Data>* op;
    BinNode<Key,Data>* neer=k;
    if (left){
        op=k->right.k;
        neer->right.k=op->left.k;
        if (op->left.k!=0)
            op->left.k->parent=neer;
        op->left.k=neer;
    }
    else{
        op=k->left.k;
        neer->left.k=op->right.k;
        if (op->right.k!=0)
            op->right.k->parent=neer;
        op->right.k=neer;
    }
    k=op;
    op->parent=neer->parent;
    neer->parent=op;
}


template <class Key,class Data>
void BinSearchTree<Key,Data>::searchPosition(const Key& key,BinTree<Key,Data>*& position,
                                         BinNode<Key,Data>*& parent){
    position=&deBinTree;
    parent=0;
    while (position->k!=0 && position->k->key!=key){
        parent=position->k;
        if (key<position->k->key)
            position=&(position->k->left);
        else
            position=&(position->k->right);
    }
}
        
template <class Key,class Data>
Data* BinSearchTree<Key,Data>::ptr2data(const Key& key){
    BinTree<Key,Data>* position;
    BinNode<Key,Data>* parent;
    searchPosition(key,position,parent);
    if (position->k==0)
        return 0;
    else return &(position->k->data);
}

template <class Key,class Data>
void BinSearchTree<Key,Data>::insert(const Key& key,const Data& data){
    BinTree<Key,Data>* position;
    BinNode<Key,Data>* parent;
    searchPosition(key,position,parent);
    if (position->k == 0){
        position->k=new BinNode<Key,Data>(key,data);
        position->k->parent=parent;
    }
}


template <class Key,class Data>
void BinSearchTree<Key,Data>::remove(const Key& key){
    BinTree<Key,Data>* position;
    BinNode<Key,Data>* parent;
    searchPosition(key,position,parent);
    BinNode<Key,Data>* weg=position->k;
    if (position->k != 0){
        if (weg->left.k==0){
            position->k=weg->right.k;
            if (position->k != 0)
                position->k->parent=parent;
            weg->right.k=0;
            delete weg;
        }
        else if (weg->right.k==0){
            position->k=weg->left.k;
            if (position->k != 0)
                position->k->parent=parent;
            weg->left.k=0;
            delete weg;
        }
        else{
            //vervangen door predecessor
            BinTree<Key,Data>* voorlink=underpredecessor(weg);
            BinNode<Key,Data>* predecessor=voorlink->k;
            if (voorlink!=&(weg->left)){
                voorlink->k=predecessor->left.k;
                if (predecessor->left.k !=0)
                    predecessor->left.k->parent=predecessor->parent;
                //geen test voor volgende twee: deze bestaan!
                position->k=predecessor;
                predecessor->parent=parent;
                predecessor->left.k=weg->left.k;
                predecessor->left.k->parent=predecessor;
                predecessor->right.k=weg->right.k;
                predecessor->right.k->parent=predecessor;
            }
            else{
                predecessor->right.k=weg->right.k;
                weg->right.k->parent=predecessor;
                predecessor->parent=weg->parent;
                position->k=predecessor;
            }
            weg->left.k=0;
            weg->right.k=0;
            delete weg;
        }
    }
}


template <class Key,class Data>
BinTree<Key,Data>* BinSearchTree<Key,Data>::underpredecessor(BinNode<Key,Data>* kn){
    BinTree<Key,Data>* under=&(kn->left);
    while (under->k->right.k!=0)
        under=&(under->k->right);
    return under;
}


#endif

