#!/bin/sh
#
# Mac OS-X compile script 
#
# note:
# GNU gcc requires libstdc++ 
#
# 100% GNU (no Xcode compilers):
#
#
#==================================================


# this ensures a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


export GROOT=/opt/gcc-11.2.0/bin
export PATH=$GROOT:$PATH

# using GNU g++ compiler...
# first, create oal.o:
$GROOT/g++ ../src/adabindings/adaOpenAL/OalBinding/oal.cpp -c \
-D obj \
-I../src/adabindings/adaOpenAL/OalBinding \
-I../src/adabindings/adaOpenAL/OalBinding/incoal


#--------------------------------------------------------


export SDKROOT=$(xcrun --show-sdk-path)
export FWROOT=/System/Library/Frameworks



$GROOT/gnatmake $1 \
-O3  \
-D $PWD/obj \
-I$PWD/../src \
-I$PWD/../src/adautils \
-I$PWD/../src/adautils/fakeTime \
-I$PWD/../src/adabindings/fake00 \
-I$PWD/../src/adabindings/adaOpenAL \
-I$PWD/../src/adabindings/adaOpenAL/OalBinding \
-largs \
oal.o \
$PWD/../libs/osx/libgnatcoll.a \
\
-L$SDKROOT/usr/lib \
-lm -lz -lstdc++ \
\
-F$FWROOT \
-framework CoreAudio \
-framework AudioUnit \
-framework AudioToolBox \
-framework OpenAL \
-pthread


mv $1 ../bin/osx/




# this option is illustrative but FTTB unnecessary:
# -mmacosx-version-min=10.13 \


# -- Copyright (C) 2022  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.

