--
-- Copyright (C) 2021  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with globals;

package aliens is

	type alienrec is record
		posX,posY,right,left,bottom,speed: integer;
	end record;

	aliens: alienrec;

	--shipnum: integer; now in globals

	aliens_max_number_x : constant integer := 10;
	aliens_max_number_y : constant integer :=  5;
	aliens_max_missiles : constant integer := 10;

	lowest_ship : array(0..aliens_max_number_x-1) of integer; --0..9
	alienshotX : array(0..aliens_max_missiles-1) of integer; -- 0..9
	alienshotY : array(0..aliens_max_missiles-1) of integer; -- 0..9

	-- 0..4,0..9 :
	alienBlock: array(0..aliens_max_number_y-1, 0..aliens_max_number_x-1) of integer;

	bunker: array(0..globals.bunkerheight-1,0..globals.bunkerwidth-1) of integer;

	procedure aliensReset;
	procedure bunkersReset;
	function aliensMove return integer;
	function aliensMissileMove return integer;
	procedure analyze;
	function aliensHitCheck( shotx, shoty: integer ) return integer;
	function bunkersHitCheck(shotx, shoty: integer) return integer;


end aliens;
