/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class EncodeChanger {
    public static final int LOWERCASE = 0;
    public static final int UPPERCASE = 1;

    public static String unicode2UnicodeEsc(String uniStr) {
        return EncodeChanger.unicode2UnicodeEsc(uniStr, 0);
    }

    public static String unicode2UnicodeEsc(String uniStr, int charcase) {
        StringBuffer ret = new StringBuffer();
        if (uniStr == null) {
            return null;
        }
        int maxLoop = uniStr.length();
        int i = 0;
        while (i < maxLoop) {
            char character = uniStr.charAt(i);
            if (character <= '\u007f') {
                ret.append(character);
            } else {
                ret.append("\\u");
                String hexStr = null;
                hexStr = charcase == 1 ? Integer.toHexString(character).toUpperCase() : Integer.toHexString(character).toLowerCase();
                int zeroCount = 4 - hexStr.length();
                int j = 0;
                while (j < zeroCount) {
                    ret.append('0');
                    ++j;
                }
                ret.append(hexStr);
            }
            ++i;
        }
        return ret.toString();
    }

    public static String unicodeEsc2Unicode(String unicodeStr) {
        if (unicodeStr == null) {
            return null;
        }
        StringBuffer retBuf = new StringBuffer();
        int maxLoop = unicodeStr.length();
        int i = 0;
        while (i < maxLoop) {
            if (unicodeStr.charAt(i) == '\\') {
                if (i < maxLoop - 5 && (unicodeStr.charAt(i + 1) == 'u' || unicodeStr.charAt(i + 1) == 'U')) {
                    try {
                        retBuf.append((char)Integer.parseInt(unicodeStr.substring(i + 2, i + 6), 16));
                        i += 5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        retBuf.append(unicodeStr.charAt(i));
                    }
                } else {
                    retBuf.append(unicodeStr.charAt(i));
                }
            } else {
                retBuf.append(unicodeStr.charAt(i));
            }
            ++i;
        }
        return retBuf.toString();
    }

    public static String unicode2UnicodeEscWithoutComment(String uniStr) throws IOException {
        return EncodeChanger.unicode2UnicodeEscWithoutComment(uniStr, 0);
    }

    public static String unicode2UnicodeEscWithoutComment(String uniStr, int charcase) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new StringReader(uniStr));
        boolean continueFlg = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line.trim().startsWith("#") || line.trim().startsWith("!")) && !continueFlg) {
                buf.append(line);
            } else {
                continueFlg = line.endsWith("\\");
                buf.append(EncodeChanger.unicode2UnicodeEsc(line, charcase));
            }
            buf.append("\n");
        }
        if (!uniStr.endsWith("\n")) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }
}

