/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.project.draw.PathUtils;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class RectangleTask {
    private final List<Segment> segments;
    private final double round;
    private final int completion;

    public RectangleTask(double startPos, double endPos, double round, int completion, Collection<Segment> paused) {
        this.round = round;
        this.completion = completion;
        this.segments = startPos < endPos ? new ArrayList<Segment>(new Segment(startPos, endPos).cutSegmentIfNeed(paused)) : Collections.singletonList(new Segment(startPos, startPos + 1.0));
    }

    private void draw2hlines(UGraphic ug, double height, ULine hline) {
        ug.draw(hline);
        ug.apply(UTranslate.dy(height)).draw(hline);
    }

    private void drawRect(UGraphic ug, int completion, HColor documentBackground, double width, double height) {
        if (completion == 100 || completion == 0) {
            if (completion == 0) {
                ug = ug.apply(documentBackground.bg());
            }
            URectangle rect = new URectangle(width, height);
            ug.draw(rect);
        } else {
            URectangle rect1 = new URectangle(width * (double)completion / 100.0, height);
            ug.draw(rect1);
            URectangle rect2 = new URectangle(width * (double)(100 - completion) / 100.0, height);
            ug.apply(documentBackground.bg()).apply(UTranslate.dx(width * (double)completion / 100.0)).draw(rect2);
        }
    }

    public void draw(UGraphic ug, double height, HColor documentBackground, boolean oddStart, boolean oddEnd) {
        if (this.round == 0.0) {
            this.drawWithoutRound(ug, height, documentBackground, oddStart, oddEnd);
            return;
        }
        if (this.segments.size() != 1) {
            this.drawWithRound(ug, height, documentBackground);
            return;
        }
        assert (this.segments.size() == 1);
        assert (this.round > 0.0);
        Segment segment = this.segments.get(0);
        double width = segment.getLength();
        URectangle partial = new URectangle(width, height).rounded(this.round);
        if (this.completion == 100 || this.completion == 0) {
            if (this.completion == 0) {
                ug = ug.apply(documentBackground.bg());
            }
            if (oddStart && !oddEnd) {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(PathUtils.UtoRight(width, height, this.round));
            } else if (!oddStart && oddEnd) {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(PathUtils.UtoLeft(width, height, this.round));
            } else {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(partial);
            }
        } else {
            double x1 = width * (double)this.completion / 100.0;
            ug.apply(new HColorNone()).apply(UTranslate.dx(segment.getPos1())).draw(PathUtils.UtoLeft(x1, height, this.round));
            ug.apply(documentBackground.bg()).apply(new HColorNone()).apply(UTranslate.dx(segment.getPos1() + x1)).draw(PathUtils.UtoRight(width * (double)(100 - this.completion) / 100.0, height, this.round));
            ug.apply(new HColorNone().bg()).apply(UTranslate.dx(segment.getPos1())).draw(partial);
        }
    }

    private void drawWithRound(UGraphic ug, double height, HColor documentBackground) {
        Segment first = this.segments.get(0);
        ug.apply(UTranslate.dx(first.getPos1())).draw(PathUtils.UtoLeft(first.getLength(), height, this.round));
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            Segment segment = this.segments.get(i);
            this.drawPartly(ug, segment, height, documentBackground, i);
        }
        Segment last = this.segments.get(this.segments.size() - 1);
        ug.apply(UTranslate.dx(last.getPos1())).draw(PathUtils.UtoRight(last.getLength(), height, this.round));
        this.drawIntermediateDotted(ug, height);
    }

    private void drawWithoutRound(UGraphic ug, double height, HColor documentBackground, boolean oddStart, boolean oddEnd) {
        ULine vline = ULine.vline(height);
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment segment = this.segments.get(i);
            this.drawPartly(ug, segment, height, documentBackground, i);
            if (!oddStart && i == 0) {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(vline);
            }
            if (oddEnd || i != this.segments.size() - 1) continue;
            ug.apply(UTranslate.dx(segment.getPos2())).draw(vline);
        }
        this.drawIntermediateDotted(ug, height);
    }

    private void drawIntermediateDotted(UGraphic ug, double height) {
        ug = ug.apply(new UStroke(2.0, 3.0, 1.0));
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            double v1 = this.segments.get(i).getPos2() + 3.0;
            double v2 = this.segments.get(i + 1).getPos1() - 3.0;
            if (!(v2 > v1)) continue;
            this.draw2hlines(ug.apply(UTranslate.dx(v1)), height, ULine.hline(v2 - v1));
        }
    }

    private void drawPartly(UGraphic ug, Segment segment, double height, HColor documentBackground, int i) {
        double width = segment.getLength();
        if (i != this.segments.size() - 1) {
            width += 1.0;
        }
        if (width > 0.0) {
            this.drawRect(ug.apply(new HColorNone()).apply(UTranslate.dx(segment.getPos1())), this.completion, documentBackground, width, height);
        }
        double pos1 = segment.getPos1();
        double len = segment.getLength();
        if (i == 0) {
            if (this.segments.size() > 1) {
                len -= 1.0;
            }
        } else {
            pos1 += 1.0;
            len -= 1.0;
        }
        if (len > 0.0) {
            this.draw2hlines(ug.apply(UTranslate.dx(pos1)), height, ULine.hline(len));
        }
    }
}

