/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.wbs.ITF;
import net.sourceforge.plantuml.wbs.ITFLeaf;
import net.sourceforge.plantuml.wbs.WBSTextBlock;
import net.sourceforge.plantuml.wbs.WElement;

class ITFComposed
extends WBSTextBlock
implements ITF {
    private final List<ITF> left;
    private final List<ITF> right;
    private final TextBlock main;
    private final double delta1x = 10.0;
    private final double marginBottom;

    private ITFComposed(ISkinParam skinParam, WElement idea, List<ITF> left, List<ITF> right) {
        super(skinParam, idea.getStyleBuilder(), idea.getLevel());
        this.left = left;
        this.right = right;
        this.main = this.buildMain(idea);
        Style style = idea.getStyle();
        this.marginBottom = style.getMargin().getBottom();
    }

    public static ITF build2(ISkinParam skinParam, WElement idea) {
        if (idea.isLeaf()) {
            return new ITFLeaf(idea.getStyle(), idea.withBackColor(skinParam), idea.getLabel(), idea.getShape());
        }
        ArrayList<ITF> left = new ArrayList<ITF>();
        ArrayList<ITF> right = new ArrayList<ITF>();
        for (WElement child : idea.getChildren(Direction.LEFT)) {
            left.add(ITFComposed.build2(skinParam, child));
        }
        for (WElement child : idea.getChildren(Direction.RIGHT)) {
            right.add(ITFComposed.build2(skinParam, child));
        }
        return new ITFComposed(skinParam, idea, left, right);
    }

    protected final double getw1(StringBounder stringBounder) {
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double mainWidth = mainDim.getWidth();
        return Math.max(mainWidth / 2.0, 10.0 + this.getCollWidth(stringBounder, this.left));
    }

    @Override
    public final Point2D getT1(StringBounder stringBounder) {
        double x = this.getw1(stringBounder);
        double y = 0.0;
        return new Point2D.Double(x, 0.0);
    }

    @Override
    public final Point2D getT2(StringBounder stringBounder) {
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double x = this.getw1(stringBounder);
        double y = mainDim.getHeight();
        return new Point2D.Double(x, y);
    }

    @Override
    public final Point2D getF1(StringBounder stringBounder) {
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double x = this.getw1(stringBounder) - mainDim.getWidth() / 2.0;
        double y = mainDim.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    @Override
    public final Point2D getF2(StringBounder stringBounder) {
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double x = this.getw1(stringBounder) + mainDim.getWidth() / 2.0;
        double y = mainDim.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    @Override
    public final Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double mainWidth = mainDim.getWidth();
        double height = mainDim.getHeight() + Math.max(this.getCollHeight(stringBounder, this.left, this.marginBottom), this.getCollHeight(stringBounder, this.right, this.marginBottom));
        double width = Math.max(mainWidth / 2.0, 10.0 + this.getCollWidth(stringBounder, this.left)) + Math.max(mainWidth / 2.0, 10.0 + this.getCollWidth(stringBounder, this.right));
        return new Dimension2DDouble(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        double y;
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D mainDim = this.main.calculateDimension(stringBounder);
        double wx = this.getw1(stringBounder) - mainDim.getWidth() / 2.0;
        this.main.drawU(ug.apply(UTranslate.dx(wx)));
        double x = this.getw1(stringBounder);
        double lastY1 = y = mainDim.getHeight();
        for (ITF child : this.left) {
            Dimension2D childDim = child.calculateDimension(stringBounder);
            lastY1 = (y += this.marginBottom) + child.getF2(stringBounder).getY();
            this.drawLine(ug, x - childDim.getWidth() - 10.0 + child.getF2(stringBounder).getX(), lastY1, x, lastY1);
            child.drawU(ug.apply(new UTranslate(x - childDim.getWidth() - 10.0, y)));
            y += childDim.getHeight();
        }
        double lastY2 = y = mainDim.getHeight();
        for (ITF child : this.right) {
            Dimension2D childDim = child.calculateDimension(stringBounder);
            lastY2 = (y += this.marginBottom) + child.getF1(stringBounder).getY();
            this.drawLine(ug, x, lastY2, x + 10.0 + child.getF1(stringBounder).getX(), lastY2);
            child.drawU(ug.apply(new UTranslate(x + 10.0, y)));
            y += childDim.getHeight();
        }
        this.drawLine(ug, x, mainDim.getHeight(), x, Math.max(lastY1, lastY2));
    }

    private final double getCollWidth(StringBounder stringBounder, Collection<? extends TextBlock> all) {
        double result = 0.0;
        for (TextBlock textBlock : all) {
            result = Math.max(result, textBlock.calculateDimension(stringBounder).getWidth());
        }
        return result;
    }

    private final double getCollHeight(StringBounder stringBounder, Collection<? extends TextBlock> all, double deltay) {
        double result = 0.0;
        for (TextBlock textBlock : all) {
            result += deltay + textBlock.calculateDimension(stringBounder).getHeight();
        }
        return result;
    }
}

