﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/alexaforbusiness/model/MeetingSetting.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace AlexaForBusiness
{
namespace Model
{

MeetingSetting::MeetingSetting() : 
    m_requirePin(RequirePin::NOT_SET),
    m_requirePinHasBeenSet(false)
{
}

MeetingSetting::MeetingSetting(JsonView jsonValue) : 
    m_requirePin(RequirePin::NOT_SET),
    m_requirePinHasBeenSet(false)
{
  *this = jsonValue;
}

MeetingSetting& MeetingSetting::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("RequirePin"))
  {
    m_requirePin = RequirePinMapper::GetRequirePinForName(jsonValue.GetString("RequirePin"));

    m_requirePinHasBeenSet = true;
  }

  return *this;
}

JsonValue MeetingSetting::Jsonize() const
{
  JsonValue payload;

  if(m_requirePinHasBeenSet)
  {
   payload.WithString("RequirePin", RequirePinMapper::GetNameForRequirePin(m_requirePin));
  }

  return payload;
}

} // namespace Model
} // namespace AlexaForBusiness
} // namespace Aws
