﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/ecs/model/AttachmentStateChange.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ECS
{
namespace Model
{

AttachmentStateChange::AttachmentStateChange() : 
    m_attachmentArnHasBeenSet(false),
    m_statusHasBeenSet(false)
{
}

AttachmentStateChange::AttachmentStateChange(JsonView jsonValue) : 
    m_attachmentArnHasBeenSet(false),
    m_statusHasBeenSet(false)
{
  *this = jsonValue;
}

AttachmentStateChange& AttachmentStateChange::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("attachmentArn"))
  {
    m_attachmentArn = jsonValue.GetString("attachmentArn");

    m_attachmentArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("status"))
  {
    m_status = jsonValue.GetString("status");

    m_statusHasBeenSet = true;
  }

  return *this;
}

JsonValue AttachmentStateChange::Jsonize() const
{
  JsonValue payload;

  if(m_attachmentArnHasBeenSet)
  {
   payload.WithString("attachmentArn", m_attachmentArn);

  }

  if(m_statusHasBeenSet)
  {
   payload.WithString("status", m_status);

  }

  return payload;
}

} // namespace Model
} // namespace ECS
} // namespace Aws
