﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/mediaconvert/model/JobPhase.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace MediaConvert
  {
    namespace Model
    {
      namespace JobPhaseMapper
      {

        static const int PROBING_HASH = HashingUtils::HashString("PROBING");
        static const int TRANSCODING_HASH = HashingUtils::HashString("TRANSCODING");
        static const int UPLOADING_HASH = HashingUtils::HashString("UPLOADING");


        JobPhase GetJobPhaseForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == PROBING_HASH)
          {
            return JobPhase::PROBING;
          }
          else if (hashCode == TRANSCODING_HASH)
          {
            return JobPhase::TRANSCODING;
          }
          else if (hashCode == UPLOADING_HASH)
          {
            return JobPhase::UPLOADING;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<JobPhase>(hashCode);
          }

          return JobPhase::NOT_SET;
        }

        Aws::String GetNameForJobPhase(JobPhase enumValue)
        {
          switch(enumValue)
          {
          case JobPhase::PROBING:
            return "PROBING";
          case JobPhase::TRANSCODING:
            return "TRANSCODING";
          case JobPhase::UPLOADING:
            return "UPLOADING";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace JobPhaseMapper
    } // namespace Model
  } // namespace MediaConvert
} // namespace Aws
