﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/model/SortOrder.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p>A collection of attributes used for sorting findings.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/SortCriterion">AWS
   * API Reference</a></p>
   */
  class AWS_SECURITYHUB_API SortCriterion
  {
  public:
    SortCriterion();
    SortCriterion(Aws::Utils::Json::JsonView jsonValue);
    SortCriterion& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline const Aws::String& GetField() const{ return m_field; }

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline bool FieldHasBeenSet() const { return m_fieldHasBeenSet; }

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline void SetField(const Aws::String& value) { m_fieldHasBeenSet = true; m_field = value; }

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline void SetField(Aws::String&& value) { m_fieldHasBeenSet = true; m_field = std::move(value); }

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline void SetField(const char* value) { m_fieldHasBeenSet = true; m_field.assign(value); }

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline SortCriterion& WithField(const Aws::String& value) { SetField(value); return *this;}

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline SortCriterion& WithField(Aws::String&& value) { SetField(std::move(value)); return *this;}

    /**
     * <p>The finding attribute used for sorting findings.</p>
     */
    inline SortCriterion& WithField(const char* value) { SetField(value); return *this;}


    /**
     * <p>The order used for sorting findings.</p>
     */
    inline const SortOrder& GetSortOrder() const{ return m_sortOrder; }

    /**
     * <p>The order used for sorting findings.</p>
     */
    inline bool SortOrderHasBeenSet() const { return m_sortOrderHasBeenSet; }

    /**
     * <p>The order used for sorting findings.</p>
     */
    inline void SetSortOrder(const SortOrder& value) { m_sortOrderHasBeenSet = true; m_sortOrder = value; }

    /**
     * <p>The order used for sorting findings.</p>
     */
    inline void SetSortOrder(SortOrder&& value) { m_sortOrderHasBeenSet = true; m_sortOrder = std::move(value); }

    /**
     * <p>The order used for sorting findings.</p>
     */
    inline SortCriterion& WithSortOrder(const SortOrder& value) { SetSortOrder(value); return *this;}

    /**
     * <p>The order used for sorting findings.</p>
     */
    inline SortCriterion& WithSortOrder(SortOrder&& value) { SetSortOrder(std::move(value)); return *this;}

  private:

    Aws::String m_field;
    bool m_fieldHasBeenSet;

    SortOrder m_sortOrder;
    bool m_sortOrderHasBeenSet;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
