/***********************************************************************************************************************************
Command and Option Definition

Automatically generated by Build.pm -- do not modify directly.
***********************************************************************************************************************************/

/***********************************************************************************************************************************
Command define data
***********************************************************************************************************************************/
static ConfigDefineCommandData configDefineCommandData[] = CFGDEFDATA_COMMAND_LIST
(
    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("archive-get")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Get a WAL segment from the archive.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "WAL segments are required for restoring a PostgreSQL cluster or maintaining a replica."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("archive-push")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Push a WAL segment to the archive.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "The WAL segment may be pushed immediately to the archive or stored locally depending on the value of archive-async"
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("backup")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Backup a database cluster.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "pgBackRest does not have a built-in scheduler so it's best to run it from cron or some other scheduling mechanism."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("check")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Check the configuration.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "The check command validates that pgBackRest and the archive_command setting are configured correctly for archiving "
                "and backups. It detects misconfigurations, particularly in archiving, that result in incomplete backups because "
                "required WAL segments did not reach the archive. The command can be run on the database or the repository host. "
                "The command may also be run on the standby host, however, since pg_switch_xlog()/pg_switch_wal() cannot be "
                "performed on the standby, the command will only test the repository configuration.\n"
            "\n"
            "Note that pg_create_restore_point('pgBackRest Archive Check') and pg_switch_xlog()/pg_switch_wal() are called to "
                "force PostgreSQL to archive a WAL segment. Restore points are only supported in PostgreSQL >= 9.1 so for older "
                "versions the check command may fail if there has been no write activity since the last log rotation, therefore it "
                "is recommended that activity be generated by the user if there have been no writes since the last WAL switch "
                "before running the check command."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("expire")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Expire backups that exceed retention.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "pgBackRest does backup rotation but is not concerned with when the backups were created. If two full backups are "
                "configured for retention, pgBackRest will keep two full backups no matter whether they occur two hours or two "
                "weeks apart."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("help")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Get help.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Three levels of help are provided. If no command is specified then general help will be displayed. If a command is "
                "specified then a full description of the command will be displayed along with a list of valid options. If an "
                "option is specified in addition to a command then the a full description of the option as it applies to the "
                "command will be displayed."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("info")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Retrieve information about backups.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "The info command operates on a single stanza or all stanzas. Text output is the default and gives a human-readable "
                "summary of backups for the stanza(s) requested. This format is subject to change with any release.\n"
            "\n"
            "For machine-readable output use --output=json. The JSON output contains far more information than the text output and "
                "is kept stable unless a bug is found."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("repo-create")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Create the repository.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Creates the bucket if repo-type=s3.\n"
            "\n"
            "FOR INTERNAL USE ONLY. DO NOT USE ON A PRODUCTION REPOSITORY."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("repo-get")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Get a file from the repository.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Similar to the unix cat command but options are different."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("repo-ls")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("List paths/files in the repository.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Similar to the unix ls command but options and output are different. Only information provided by repository storage "
                "drivers is available: name, type, size, (modify) time, and destination (for drivers that support links)."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("repo-put")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Put a file in the repository.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Similar to the unix tee command but options and behavior are different.\n"
            "\n"
            "FOR INTERNAL USE ONLY. DO NOT USE ON A PRODUCTION REPOSITORY."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("repo-rm")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Remove paths/files in the repository.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Similar to the unix rm command but options are different.\n"
            "\n"
            "FOR INTERNAL USE ONLY. DO NOT USE ON A PRODUCTION REPOSITORY."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("restore")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Restore a database cluster.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "This command is generally run manually, but there are instances where it might be automated."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("stanza-create")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Create the required stanza data.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "The stanza-create command must be run on the host where the repository is located after the stanza has been "
                "configured in pgbackrest.conf."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("stanza-delete")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Delete a stanza.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "The stanza-delete command removes data in the repository associated with a stanza.\n"
            "WARNING: Use this command with caution -- it will permanently remove all backups and archives from the pgBackRest "
                "repository for the specified stanza.\n"
            "\n"
            "\n"
            "To delete a stanza:\n"
            "\n"
            "* Shut down the PostgreSQL cluster associated with the stanza (or use --force to override).\n"
            "* Run the stop command on the repository host.\n"
            "* Run the stanza-delete command on the repository host.\n"
            "\n"
            "Once the command successfully completes, it is the responsibility of the user to remove the stanza from all "
                "pgBackRest configuration files."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("stanza-upgrade")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Upgrade a stanza.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Immediately after upgrading PostgreSQL to a newer major version, the pg-path for all pgBackRest configurations must "
                "be set to the new database location and the stanza-upgrade run on the repository host. If the database is offline "
                "use the --no-online option."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("start")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Allow pgBackRest processes to run.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "If the pgBackRest processes were previously stopped using the stop command then they can be started again using the "
                "start command. Note that this will not immediately start up any pgBackRest processes but they are allowed to run."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("stop")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Stop pgBackRest processes from running.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Does not allow any new pgBackRest processes to run. By default running processes will be allowed to complete "
                "successfully. Use the --force option to terminate running processes.\n"
            "\n"
            "pgBackRest processes will return an error if they are run after the stop command completes."
        )
    )

    CFGDEFDATA_COMMAND
    (
        CFGDEFDATA_COMMAND_NAME("version")

        CFGDEFDATA_COMMAND_HELP_SUMMARY("Get version.")
        CFGDEFDATA_COMMAND_HELP_DESCRIPTION
        (
            "Displays installed pgBackRest version."
        )
    )
)

/***********************************************************************************************************************************
Option define data
***********************************************************************************************************************************/
static ConfigDefineOptionData configDefineOptionData[] = CFGDEFDATA_OPTION_LIST
(
    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-async")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("archive")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Push/get WAL segments asynchronously.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Enables asynchronous operation for the archive-push and archive-get commands.\n"
            "\n"
            "Asynchronous operation is more efficient because it can reuse connections and take advantage of parallelism. See the "
                "spool-path, archive-get-queue-max, and archive-push-queue-max options for more information."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-check")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Check that WAL segments are in the archive before backup completes.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Checks that all WAL segments required to make the backup consistent are present in the WAL archive. It's a good idea "
                "to leave this as the default unless you are using another method for archiving.\n"
            "\n"
            "This option must be enabled if archive-copy is enabled."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptOnline,
                    "1"
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-copy")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Copy WAL segments needed for consistency to the backup.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This slightly paranoid option protects against corruption in the WAL segment archive by storing the WAL segments "
                "required for consistency directly in the backup. WAL segments are still stored in the archive so this option will "
                "use additional space.\n"
            "\n"
            "On restore, the WAL segments will be present in pg_xlog/pg_wal and PostgreSQL will use them in preference to calling "
                "the restore_command.\n"
            "\n"
            "The archive-check option must be enabled if archive-copy is enabled."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptArchiveCheck,
                    "1"
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-get-queue-max")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeSize)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("archive")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Maximum size of the pgBackRest archive-get queue.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Specifies the maximum size of the archive-get queue when archive-async is enabled. The queue is stored in the "
                "spool-path and is used to speed providing WAL to PostgreSQL.\n"
            "\n"
            "Size can be entered in bytes (default) or KB, MB, GB, TB, or PB where the multiplier is a power of 1024."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 4503599627370496)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("134217728")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-mode")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Preserve or disable archiving on restored cluster.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This option allows archiving to be preserved or disabled on a restored cluster. This is useful when the cluster must "
                "be promoted to do some work but is not intended to become the new primary. In this case it is not a good idea to "
                "push WAL from the cluster into the repository.\n"
            "\n"
            "The following modes are supported:\n"
            "\n"
            "* off - disable archiving by setting archive_mode=off.\n"
            "* preserve - preserve current archive_mode setting.\n"
            "\n"
            "NOTE: This option is not available on PostgreSQL < 12."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "off",
                "preserve"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("preserve")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-push-queue-max")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeSize)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("archive")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Maximum size of the PostgreSQL archive queue.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "After the limit is reached, the following will happen:\n"
            "\n"
            "* pgBackRest will notify PostgreSQL that the WAL was successfully archived, then DROP IT.\n"
            "* A warning will be output to the Postgres log.\n"
            "\n"
            "If this occurs then the archive log stream will be interrupted and PITR will not be possible past that point. A new "
                "backup will be required to regain full restore capability.\n"
            "\n"
            "In asynchronous mode the entire queue will be dropped to prevent spurts of WAL getting through before the queue limit "
                "is exceeded again.\n"
            "\n"
            "The purpose of this feature is to prevent the log volume from filling up at which point Postgres will stop "
                "completely. Better to lose the backup than have PostgreSQL go down.\n"
            "\n"
            "Size can be entered in bytes (default) or KB, MB, GB, TB, or PB where the multiplier is a power of 1024."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 4503599627370496)
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("archive-queue-max")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("archive-timeout")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeFloat)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("archive")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Archive timeout.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Set maximum time, in seconds, to wait for each WAL segment to reach the pgBackRest archive repository. The timeout "
                "applies to the check and backup commands when waiting for WAL segments required for backup consistency to be "
                "archived."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0.1, 86400)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("60")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("backup-standby")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Backup from the standby cluster.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Enable backup from standby to reduce load on the primary cluster. This option requires that both the primary and "
                "standby hosts be configured."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("buffer-size")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeSize)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Buffer size for file operations.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Set the buffer size used for copy, compress, and uncompress functions. A maximum of 3 buffers will be in use at a "
                "time per process. An additional maximum of 256K per process may be used for zlib buffers.\n"
            "\n"
            "Size can be entered in bytes (default) or KB, MB, GB, TB, or PB where the multiplier is a power of 1024. For example, "
                "the case-insensitive value 32k (or 32KB) can be used instead of 32768.\n"
            "\n"
            "Allowed values, in bytes, are 16384, 32768, 65536, 131072, 262144, 524288, 1048576, 2097152, 4194304, 8388608, and "
                "16777216."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "16384",
                "32768",
                "65536",
                "131072",
                "262144",
                "524288",
                "1048576",
                "2097152",
                "4194304",
                "8388608",
                "16777216"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1048576")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("checksum-page")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Validate data page checksums.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Directs pgBackRest to validate all data page checksums while backing up a cluster. This option is automatically "
                "enabled when data page checksums are enabled on the cluster.\n"
            "\n"
            "Failures in checksum validation will not abort a backup. Rather, warnings will be emitted in the log (and to the "
                "console with default settings) and the list of invalid pages will be stored in the backup manifest."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("cipher-pass")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("cmd-ssh")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Path to ssh client executable.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use a specific SSH client when an alternate is desired or the ssh executable is not in $PATH."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("ssh")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("compress")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Use file compression.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Backup files are compatible with command-line compression tools.\n"
            "\n"
            "This option is now deprecated. The compress-type option should be used instead."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("compress-level")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("File compression level.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the level to be used for file compression when compress-type does not equal none or compress=y (deprecated)."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 9)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("compress-level-network")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Network compression level.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the network compression level when compress-type=none and the command is not run on the same host as the "
                "repository. Compression is used to reduce network traffic but can be disabled by setting "
                "compress-level-network=0. When compress-type does not equal none the compress-level-network setting is ignored "
                "and compress-level is used instead so that the file is only compressed once. SSH compression is always disabled."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 9)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("3")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("compress-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("File compression type.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following compression types are supported:\n"
            "\n"
            "* none - no compression\n"
            "* bz2 - bzip2 compression format\n"
            "* gz - gzip compression format\n"
            "* lz4 - lz4 compression format (not available on all platforms)\n"
            "* zst - Zstandard compression format (not available on all platforms)"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "none",
                "bz2",
                "gz",
                "lz4",
                "zst"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("gz")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("config")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest configuration file.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use this option to specify a different configuration file than the default."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest/pgbackrest.conf")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("config-include-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Path to additional pgBackRest configuration files.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Configuration files existing in the specified location with extension .conf will be concatenated with the pgBackRest "
                "configuration file, resulting in one configuration file."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest/conf.d")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("config-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Base path of pgBackRest configuration files.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This setting is used to override the default base path setting for the --config and --config-include-path options "
                "unless they are explicitly set on the command-line.\n"
            "\n"
            "For example, passing only --config-path=/conf/pgbackrest results in the --config default being set to "
                "/conf/pgbackrest/pgbackrest.conf and the --config-include-path default being set to /conf/pgbackrest/conf.d."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("db-include")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeList)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Restore only specified databases.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This feature allows only selected databases to be restored. Databases not specifically included will be restored as "
                "sparse, zeroed files to save space but still allow PostgreSQL to perform recovery. After recovery the databases "
                "that were not included will not be accessible but can be removed with the drop database command. \n"
            "NOTE: built-in databases (template0, template1, and postgres) are always restored.\n"
            "\n"
            "The --db-include option can be passed multiple times to specify more than one database to include."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("db-timeout")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeFloat)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Database query timeout.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the timeout, in seconds, for queries against the database. This includes the pg_start_backup() and "
                "pg_stop_backup() functions which can each take a substantial amount of time. Because of this the timeout should "
                "be kept high unless you know that these functions will return quickly (i.e. if you have set startfast=y and you "
                "know that the database cluster will not generate many WAL segments during the backup). \n"
            "NOTE: The db-timeout option must be less than the protocol-timeout option."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0.1, 604800)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1800")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("delta")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Restore or backup using checksums.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "During a restore, by default the PostgreSQL data and tablespace directories are expected to be present but empty. "
                "This option performs a delta restore using checksums.\n"
            "\n"
            "During a backup, this option will use checksums instead of the timestamps to determine if files will be copied."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("dry-run")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Execute a dry-run for the command.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The --dry-run option is a command-line only option and can be passed when it is desirable to determine what "
                "modifications will be made by the command without the command actually making any modifications."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("exclude")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeList)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Exclude paths/files from the backup.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "All exclusions are relative to $PGDATA. If the exclusion ends with / then only files in the specified directory will "
                "be excluded, e.g. --exclude=junk/ will exclude all files in the $PGDATA/junk directory but include the directory "
                "itself. If the exclusion does not end with / then the file may match the exclusion exactly or match with / "
                "appended to the exclusion, e.g. --exclude=junk will exclude the $PGDATA/junk directory and all the files it "
                "contains.\n"
            "\n"
            "Be careful using this feature -- it is very easy to exclude something critical that will make the backup "
                "inconsistent. Be sure to test your restores!\n"
            "\n"
            "All excluded files will be logged at info level along with the exclusion rule. Be sure to audit the list of excluded "
                "files to ensure nothing unexpected is being excluded.\n"
            "NOTE: Exclusions are not honored on delta restores. Any files/directories that were excluded by the backup will be "
                "removed on delta restore.\n"
            "\n"
            "This option should not be used to exclude PostgreSQL logs from a backup. Logs can be moved out of the PGDATA "
                "directory using the PostgreSQL log_directory setting, which has the benefit of allowing logs to be preserved "
                "after a restore.\n"
            "\n"
            "Multiple exclusions may be specified on the command-line or in a configuration file."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("expire-auto")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Automatically run the expire command after a successful backup.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The setting is enabled by default. Use caution when disabling this option as doing so will result in retaining all "
                "backups and archives indefinitely, which could cause your repository to run out of space. The expire command will "
                "need to be run regularly to prevent this from happening."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("filter")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoLs)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Filter output with a regular expression.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The filter is applied against the file/path names before they are output."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("force")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptOnline,
                    "0"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Force an offline backup.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "When used with --no-start-stop a backup will be run even if pgBackRest thinks that PostgreSQL is running. "
                        "This option should be used with extreme care as it will likely result in a bad backup.\n"
                    "\n"
                    "There are some scenarios where a backup might still be desirable under these conditions. For example, if a "
                        "server crashes and the database cluster volume can only be mounted read-only, it would be a good idea to "
                        "take a backup even if postmaster.pid is present. In this case it would be better to revert to the prior "
                        "backup and replay WAL, but possibly there is a very important transaction in a WAL segment that did not "
                        "get archived."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Force a restore.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "By itself this option forces the PostgreSQL data and tablespace paths to be completely overwritten. In "
                        "combination with --delta a timestamp/size delta will be performed instead of using checksums."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaCreate)

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaDelete)

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Force stanza delete.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "If PostgreSQL is still running for the stanza, then this option can be used to force the stanza to be deleted "
                        "from the repository."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStop)

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Force all pgBackRest processes to stop.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "This option will send TERM signals to all running pgBackRest processes to effect a graceful but immediate "
                        "shutdown. Note that this will also shutdown processes that were initiated on another system but have "
                        "remotes running on the current system. For instance, if a backup was started on the backup server then "
                        "running stop --force on the database server will shutdown the backup process on the backup server."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("host-id")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 8)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("ignore-missing")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoGet)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Ignore missing source file.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Exit with 1 if the source file is missing but don't throw an error."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("io-timeout")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeFloat)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("I/O timeout.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Timeout, in seconds, used for connections and read/write operations.\n"
            "\n"
            "Note that the entire read/write operation does not need to complete within this timeout but some progress must be "
                "made, even if it is only a single byte."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0.1, 3600)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("60")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("link-all")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Restore all symlinks.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "By default symlinked directories and files are restored as normal directories and files in $PGDATA. This is because "
                "it may not be safe to restore symlinks to their original destinations on a system other than where the original "
                "backup was performed. This option restores all the symlinks just as they were on the original system where the "
                "backup was performed."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("link-map")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeHash)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Modify the destination of a symlink.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Allows the destination file or path of a symlink to be changed on restore. This is useful for restoring to systems "
                "that have a different storage layout than the original system where the backup was generated."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("lock-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Path where lock files are stored.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The lock path provides a location for pgBackRest to create lock files to prevent conflicting operations from being "
                "run concurrently."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/tmp/pgbackrest")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("log-level-console")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("log")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Level for console logging.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following log levels are supported:\n"
            "\n"
            "* off - No logging at all (not recommended)\n"
            "* error - Log only errors\n"
            "* warn - Log warnings and errors\n"
            "* info - Log info, warnings, and errors\n"
            "* detail - Log detail, info, warnings, and errors\n"
            "* debug - Log debug, detail, info, warnings, and errors\n"
            "* trace - Log trace (very verbose debugging), debug, info, warnings, and errors"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "off",
                "error",
                "warn",
                "info",
                "detail",
                "debug",
                "trace"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("warn")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("log-level-file")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("log")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Level for file logging.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following log levels are supported:\n"
            "\n"
            "* off - No logging at all (not recommended)\n"
            "* error - Log only errors\n"
            "* warn - Log warnings and errors\n"
            "* info - Log info, warnings, and errors\n"
            "* detail - Log detail, info, warnings, and errors\n"
            "* debug - Log debug, detail, info, warnings, and errors\n"
            "* trace - Log trace (very verbose debugging), debug, info, warnings, and errors"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "off",
                "error",
                "warn",
                "info",
                "detail",
                "debug",
                "trace"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("info")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("log-level-stderr")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("log")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Level for stderr logging.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Specifies which log levels will output to stderr rather than stdout (specified by log-level-console). The timestamp "
                "and process will not be output to stderr.\n"
            "\n"
            "The following log levels are supported:\n"
            "\n"
            "* off - No logging at all (not recommended)\n"
            "* error - Log only errors\n"
            "* warn - Log warnings and errors\n"
            "* info - Log info, warnings, and errors\n"
            "* detail - Log detail, info, warnings, and errors\n"
            "* debug - Log debug, detail, info, warnings, and errors\n"
            "* trace - Log trace (very verbose debugging), debug, info, warnings, and errors"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "off",
                "error",
                "warn",
                "info",
                "detail",
                "debug",
                "trace"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("warn")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("log-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("log")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Path where log files are stored.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The log path provides a location for pgBackRest to store log files. Note that if log-level-file=off then no log path "
                "is required."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/var/log/pgbackrest")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("log-subprocess")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("log")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Enable logging in subprocesses.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Enable file logging for any subprocesses created by this process using the log level specified by log-level-file."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("log-timestamp")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("log")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Enable timestamp in logging.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Enables the timestamp in console and file logging. This option is disabled in special situations such as generating "
                "documentation."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("manifest-save-threshold")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeSize)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Manifest save threshold during backup.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Defines how often the manifest will be saved during a backup. Saving the manifest is important because it stores the "
                "checksums and allows the resume function to work efficiently. The actual threshold used is 1% of the backup size "
                "or manifest-save-threshold, whichever is greater.\n"
            "\n"
            "Size can be entered in bytes (default) or KB, MB, GB, TB, or PB where the multiplier is a power of 1024."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 1099511627776)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1073741824")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("neutral-umask")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Use a neutral umask.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the umask to 0000 so modes in the repository are created in a sensible way. The default directory mode is 0750 "
                "and default file mode is 0640. The lock and log directories set the directory and file mode to 0770 and 0660 "
                "respectively.\n"
            "\n"
            "To use the executing user's umask instead specify neutral-umask=n in the config file or --no-neutral-umask on the "
                "command line."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("online")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Perform an online backup.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Specifying --no-online prevents pgBackRest from running pg_start_backup() and pg_stop_backup() on the "
                        "database cluster. In order for this to work PostgreSQL should be shut down and pgBackRest will generate "
                        "an error if it is not.\n"
                    "\n"
                    "The purpose of this option is to allow offline backups. The pg_xlog/pg_wal directory is copied as-is and "
                        "archive-check is automatically disabled for the backup."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaCreate)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Create on an online cluster.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Specifying --no-online prevents pgBackRest from connecting to PostgreSQL when creating the stanza."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaUpgrade)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Update an online cluster.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Specifying --no-online prevents pgBackRest from connecting to PostgreSQL when upgrading the stanza."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("output")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdInfo)

                CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
                (
                    "text",
                    "json"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("text")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Output format.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The following output types are supported:\n"
                    "\n"
                    "* text - Human-readable summary of backup information.\n"
                    "* json - Exhaustive machine-readable backup information in JSON format."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoLs)

                CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
                (
                    "text",
                    "json"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("text")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Output format.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The following output types are supported:\n"
                    "\n"
                    "* text - Simple list with one file/link/path name on each line.\n"
                    "* json - Detailed file/link/path information in JSON format."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL host for operating remotely via SSH.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Used for backups where the PostgreSQL host is different from the repository host."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptPgLocal,
                "0"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-host")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchiveGet)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchivePush)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host-cmd")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest exe path on the PostgreSQL host.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Required only if the path to pgbackrest is different on the local and PostgreSQL hosts. If not defined, the database "
                "host exe path will be set the same as the local exe path."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgHost)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-cmd")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host-config")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest database host configuration file.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the location of the configuration file on the PostgreSQL host. This is only required if the PostgreSQL host "
                "configuration file is in a different location than the local configuration file."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest/pgbackrest.conf")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-config")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host-config-include-path")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest database host configuration include path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the location of the configuration include path on the PostgreSQL host. This is only required if the PostgreSQL "
                "host configuration include path is in a different location than the local configuration include path."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest/conf.d")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host-config-path")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest database host configuration path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the location of the configuration path on the PostgreSQL host. This is only required if the PostgreSQL host "
                "configuration path is in a different location than the local configuration path."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host-port")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL host port when pg-host is set.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use this option to specify a non-default port for the PostgreSQL host protocol. Currently only SSH is supported"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 65535)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgHost)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-ssh-port")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-host-user")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL host logon user when pg-host is set.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This user will also own the remote pgBackRest process and will initiate connections to PostgreSQL. For this to work "
                "correctly the user should be the PostgreSQL database cluster owner which is generally postgres, the default."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("postgres")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-user")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-local")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchiveGet)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchivePush)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL data directory.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This should be the same as the data_directory setting in postgresql.conf. Even though this value can be read from "
                "postgresql.conf or PostgreSQL it is prudent to set it in case those resources are not available during a restore "
                "or offline backup scenario.\n"
            "\n"
            "The pg-path option is tested against the value reported by PostgreSQL on every online backup so it should always be "
                "current."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-path")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchivePush)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-port")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL port.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Port that PostgreSQL is running on. This usually does not need to be specified as most PostgreSQL clusters run on the "
                "default port."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 65535)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgPath)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("5432")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-port")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-socket-path")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL unix socket path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The unix socket directory that was specified when PostgreSQL was started. pgBackRest will automatically look in the "
                "standard location for your OS so there is usually no need to specify this setting unless the socket directory was "
                "explicitly modified with the unix_socket_directory setting in postgresql.conf."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 65535)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgPath)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("db-socket-path")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("pg-user")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionStanza)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(8)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("stanza")
        CFGDEFDATA_OPTION_HELP_SUMMARY("PostgreSQL database user.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The database user name used when connecting to PostgreSQL. If not specified pgBackRest will connect with the local OS "
                "user or PGUSER."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptPgPath)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("pg")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("process")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 1024)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("process-max")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Max processes to use for compress/transfer.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Each process will perform compression and transfer to make the command run faster, but don't set process-max so high "
                "that it impacts database performance."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 999)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("protocol-timeout")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeFloat)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Protocol timeout.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the timeout, in seconds, that the local or remote process will wait for a new message to be received on the "
                "protocol layer. This prevents processes from waiting indefinitely for a message. \n"
            "NOTE: The protocol-timeout option must be greater than the db-timeout option."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0.1, 604800)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1830")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("raw")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Do not transform data.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Do not transform (i.e, encrypt, decompress, etc.) data for the current command."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("recovery-option")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeHash)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Set an option in recovery.conf.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "See http://www.postgresql.org/docs/X.X/static/recovery-config.html for details on recovery.conf options (replace X.X "
                "with your PostgreSQL version). This option can be used multiple times.\n"
            "NOTE: The restore_command option will be automatically generated but can be overridden with this option. Be careful "
                "about specifying your own restore_command as pgBackRest is designed to handle this for you. Target Recovery "
                "options (recovery_target_name, recovery_target_time, etc.) are generated automatically by pgBackRest and should "
                "not be set with this option.\n"
            "\n"
            "Since pgBackRest does not start PostgreSQL after writing the recovery.conf file, it is always possible to edit/check "
                "recovery.conf before manually restarting."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptType,
                "default",
                "immediate",
                "name",
                "time",
                "standby",
                "xid"
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("recurse")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoLs)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Include all subpaths in output.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "All subpaths and their files will be included in the output."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoRm)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Remove all sub file/paths.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "All subpaths and their files will be removed."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("remote-type")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "pg",
                "repo"
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-account")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(true)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository account.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Azure account used to store the repository."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-ca-file")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository TLS CA file.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use a CA file other than the system default."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-ca-path")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository TLS CA path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use a CA path other than the system default."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-container")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository container.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Azure container used to store the repository.\n"
            "\n"
            "pgBackRest repositories can be stored in the container root by setting repo-path=/ but it is usually best to specify "
                "a prefix, such as /repo, so logs and other Azure-generated content can also be stored in the container."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-host")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository host.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Connect to a host other than the default. This is typically used for testing."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-key")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(true)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository key.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "A shared key or shared access signature depending on the repo-azure-key-type option."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-key-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository key type.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following types are supported for authorization:\n"
            "\n"
            "* shared - Shared key\n"
            "* sas - Shared access signature"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "shared",
                "sas"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("shared")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-port")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository server port.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Port to use when connecting to the default server (or host if specified). This is typically used for testing."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 65535)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("443")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-azure-verify-tls")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Azure repository server certificate verify.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Disables verification of the Azure server certificate. This should only be used for testing or other scenarios where "
                "a certificate has been self-signed."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "azure"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-cipher-pass")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(true)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Repository cipher passphrase.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Passphrase used to encrypt/decrypt files of the repository."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoCipherType,
                "aes-256-cbc"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-cipher-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Cipher used to encrypt the repository.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following cipher types are supported:\n"
            "\n"
            "* none - The repository is not encrypted\n"
            "* aes-256-cbc - Advanced Encryption Standard with 256 bit key length\n"
            "\n"
            "Note that encryption is always performed client-side even if the repository type (e.g. S3) supports encryption."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "none",
                "aes-256-cbc"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("none")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-hardlink")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Hardlink files between backups in the repository.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Enable hard-linking of files in differential and incremental backups to their full backups. This gives the appearance "
                "that each backup is a full backup at the file-system level. Be careful, though, because modifying files that are "
                "hard-linked can affect all the backups in the set."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("hardlink")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Repository host when operating remotely via SSH.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Make sure that trusted SSH authentication is configured between the PostgreSQL host and the repository host.\n"
            "\n"
            "When backing up and archiving to a locally mounted filesystem this setting is not required."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoLocal,
                "0"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("backup-host")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdExpire)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaCreate)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaDelete)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaUpgrade)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host-cmd")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest exe path on the repository host.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Required only if the path to pgbackrest is different on the local and repository hosts. If not defined, the "
                "repository host exe path will be set the same as the local exe path."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptRepoHost)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("backup-cmd")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host-config")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest repository host configuration file.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the location of the configuration file on the repository host. This is only required if the repository host "
                "configuration file is in a different location than the local configuration file."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptRepoHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest/pgbackrest.conf")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("backup-config")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host-config-include-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest repository host configuration include path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the location of the configuration include path on the repository host. This is only required if the repository "
                "host configuration include path is in a different location than the local configuration include path."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptRepoHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest/conf.d")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host-config-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("pgBackRest repository host configuration path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Sets the location of the configuration path on the repository host. This is only required if the repository host "
                "configuration path is in a different location than the local configuration path."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptRepoHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/etc/pgbackrest")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host-port")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Repository host port when repo-host is set.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use this option to specify a non-default port for the repository host protocol. Currently only SSH is supported"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(0, 65535)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptRepoHost)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("backup-ssh-port")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-host-user")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Repository host user when repo-host is set.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Defines the user that will be used for operations on the repository host. Preferably this is not the postgres user "
                "but rather some other user like pgbackrest. If PostgreSQL runs on the repository host the postgres user can be "
                "placed in the pgbackrest group so it has read permissions on the repository without being able to damage the "
                "contents accidentally."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptRepoHost)
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("pgbackrest")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("backup-user")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-local")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdExpire)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaCreate)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaDelete)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStanzaUpgrade)

                CFGDEFDATA_OPTION_OPTIONAL_INTERNAL(true)
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Path where backups and archive are stored.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The repository is where pgBackRest stores backups and archives WAL segments.\n"
            "\n"
            "It may be difficult to estimate in advance how much space you'll need. The best thing to do is take some backups then "
                "record the size of different types of backups (full/incr/diff) and measure the amount of WAL generated per day. "
                "This will give you a general idea of how much space you'll need, though of course requirements will likely change "
                "over time as your database evolves."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/var/lib/pgbackrest")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-retention-archive")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Number of backups worth of continuous WAL to retain.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "NOTE: WAL segments required to make a backup consistent are always retained until the backup is expired regardless of "
                "how this option is configured.\n"
            "\n"
            "If this value is not set and repo-retention-full-type is count (default), then the archive to expire will default to "
                "the repo-retention-full (or repo-retention-diff) value corresponding to the repo-retention-archive-type if set to "
                "full (or diff). This will ensure that WAL is only expired for backups that are already expired. If "
                "repo-retention-full-type is time, then this value will default to removing archives that are earlier than the "
                "oldest full backup retained after satisfying the repo-retention-full setting.\n"
            "\n"
            "This option must be set if repo-retention-archive-type is set to incr. If disk space is at a premium, then this "
                "setting, in conjunction with repo-retention-archive-type, can be used to aggressively expire WAL segments. "
                "However, doing so negates the ability to perform PITR from the backups with expired WAL and is therefore not "
                "recommended."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 9999999)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("retention-archive")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-retention-archive-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Backup type for WAL retention.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "If set to full pgBackRest will keep archive logs for the number of full backups defined by repo-retention-archive. If "
                "set to diff (differential) pgBackRest will keep archive logs for the number of full and differential backups "
                "defined by repo-retention-archive, meaning if the last backup taken was a full backup, it will be counted as a "
                "differential for the purpose of repo-retention. If set to incr (incremental) pgBackRest will keep archive logs "
                "for the number of full, differential, and incremental backups defined by repo-retention-archive. It is "
                "recommended that this setting not be changed from the default which will only expire WAL in conjunction with "
                "expiring full backups."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "full",
                "diff",
                "incr"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("full")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("retention-archive-type")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-retention-diff")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Number of differential backups to retain.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "When a differential backup expires, all incremental backups associated with the differential backup will also expire. "
                "When not defined all differential backups will be kept until the full backups they depend on expire."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 9999999)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("retention-diff")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-retention-full")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Full backup retention count/time.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "When a full backup expires, all differential and incremental backups associated with the full backup will also "
                "expire. When the option is not defined a warning will be issued. If indefinite retention is desired then set the "
                "option to the max value."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 9999999)
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("retention-full")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-retention-full-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Retention type for full backups.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Determines whether the repo-retention-full setting represents a time period (days) or count of full backups to keep. "
                "If set to time then full backups older than repo-retention-full will be removed from the repository if there is "
                "at least one backup that is equal to or greater than the repo-retention-full setting. For example, if "
                "repo-retention-full is 30 (days) and there are 2 full backups: one 25 days old and one 35 days old, no full "
                "backups will be expired because expiring the 35 day old backup would leave only the 25 day old backup, which "
                "would violate the 30 day retention policy of having at least one backup 30 days old before an older one can be "
                "expired. Archived WAL older than the oldest full backup remaining will be automatically expired unless "
                "repo-retention-archive-type and repo-retention-archive are explicitly set."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "count",
                "time"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("count")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-bucket")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository bucket.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "S3 bucket used to store the repository.\n"
            "\n"
            "pgBackRest repositories can be stored in the bucket root by setting repo-path=/ but it is usually best to specify a "
                "prefix, such as /repo, so logs and other AWS generated content can also be stored in the bucket."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-ca-file")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 SSL CA File.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use a CA file other than the system default."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-ca-path")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 SSL CA Path.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Use a CA path other than the system default."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-endpoint")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository endpoint.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The AWS end point should be valid for the selected region."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-host")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository host.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Connect to a host other than the end point. This is typically used for testing."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-key")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(true)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository access key.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "AWS key used to access this bucket."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoS3KeyType,
                "shared"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-key-secret")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(true)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository secret access key.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "AWS secret key used to access this bucket."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoS3KeyType,
                "shared"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-key-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository key type.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following types are supported:\n"
            "\n"
            "* shared - Shared keys\n"
            "* auto - Automatically retrieve temporary credentials"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "shared",
                "auto"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("shared")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-port")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository port.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Port to use when connecting to the endpoint (or host if specified)."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 65535)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("443")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-region")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository region.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The AWS region where the bucket was created."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-role")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository role.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "AWS role used to retrieve temporary credentials when repo-s3-key-type=auto."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoS3KeyType,
                "auto"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-token")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(true)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 repository security token.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "AWS security token used with temporary credentials."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoS3KeyType,
                "shared"
            )

            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-uri-style")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("S3 URI Style.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following URI styles are supported:\n"
            "\n"
            "* host - Connect to bucket.endpoint host.\n"
            "* path - Connect to endpoint host and prepend bucket to URIs."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "host",
                "path"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("host")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-s3-verify-tls")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Verify S3 server certificate.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Disables verification of the S3 server certificate. This should only be used for testing or other scenarios where a "
                "certificate has been self-signed."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptRepoType,
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
            CFGDEFDATA_OPTION_OPTIONAL_HELP_NAME_ALT("repo-s3-verify-ssl")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("repo-type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("repository")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Type of storage used for the repository.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "The following repository types are supported:\n"
            "\n"
            "* azure - Azure Blob Storage Service\n"
            "* cifs - Like posix, but disables links and directory fsyncs\n"
            "* posix - Posix-compliant file systems\n"
            "* s3 - AWS Simple Storage Service"
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "azure",
                "cifs",
                "posix",
                "s3"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("posix")
            CFGDEFDATA_OPTION_OPTIONAL_PREFIX("repo")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("resume")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Allow resume of failed backup.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Defines whether the resume feature is enabled. Resume can greatly reduce the amount of time required to run a backup "
                "after a previous backup of the same type has failed. It adds complexity, however, so it may be desirable to "
                "disable in environments that do not require the feature."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("sck-block")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(true)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("sck-keep-alive")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Keep-alive enable.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Enables keep-alive messages on socket connections."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("1")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("set")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdExpire)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Backup set to expire.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The specified backup set (i.e. the backup label provided and all of its dependent backups, if any) will be "
                        "expired regardless of backup retention rules except that at least one full backup must remain in the "
                        "repository. \n"
                    "WARNING: Use this option with extreme caution -- it will permanently remove all backups and archives not "
                        "required to make a backup consistent from the pgBackRest repository for the specified backup set. This "
                        "process may negate the ability to perform PITR. If --repo-retention-full and/or --repo-retention-archive "
                        "options are configured, then it is recommended that you override these options by setting their values to "
                        "the maximum while performing adhoc expiration."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdInfo)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND(cfgDefOptStanza)
                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Backup set to detail.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Details include a list of databases (with OIDs) in the backup set (excluding template databases), tablespaces "
                        "(with OIDs) with the destination where they will be restored by default, and symlinks with the "
                        "destination where they will be restored when --link-all is specified."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("latest")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Backup set to restore.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The backup set to be restored. latest will restore the latest backup, otherwise provide the name of the "
                        "backup to restore."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("sort")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
            (
                "none",
                "asc",
                "desc"
            )

            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("asc")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoLs)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Sort output ascending, descending, or none.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The following sort types are supported:\n"
                    "\n"
                    "* asc - sort ascending.\n"
                    "* desc - sort descending.\n"
                    "* none - no sorting."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("spool-path")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypePath)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Path where transient data is stored.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This path is used to store data for the asynchronous archive-push and archive-get command.\n"
            "\n"
            "The asynchronous archive-push command writes acknowledgements into the spool path when it has successfully stored WAL "
                "in the archive (and errors on failure) so the foreground process can quickly notify PostgreSQL. Acknowledgement "
                "files are very small (zero on success and a few hundred bytes on error).\n"
            "\n"
            "The asynchronous archive-get command queues WAL in the spool path so it can be provided very quickly when PostgreSQL "
                "requests it. Moving files to PostgreSQL is most efficient when the spool path is on the same filesystem as "
                "pg_xlog/pg_wal.\n"
            "\n"
            "The data stored in the spool path is not strictly temporary since it can and should survive a reboot. However, loss "
                "of the data in the spool path is not a problem. pgBackRest will simply recheck each WAL segment to ensure it is "
                "safely archived for archive-push and rebuild the queue for archive-get.\n"
            "\n"
            "The spool path is intended to be located on a local Posix-compatible filesystem, not a remote filesystem such as NFS "
                "or CIFS."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("/var/spool/pgbackrest")

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchiveGet)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptArchiveAsync,
                    "1"
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdArchivePush)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptArchiveAsync,
                    "1"
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("stanza")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Defines the stanza.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "A stanza is the configuration for a PostgreSQL database cluster that defines where it is located, how it will be "
                "backed up, archiving options, etc. Most db servers will only have one Postgres database cluster and therefore one "
                "stanza, whereas backup servers will have a stanza for every database cluster that needs to be backed up.\n"
            "\n"
            "It is tempting to name the stanza after the primary cluster but a better name describes the databases contained in "
                "the cluster. Because the stanza name will be used for the primary and all replicas it is more appropriate to "
                "choose a name that describes the actual function of the cluster, such as app or dw, rather than the local cluster "
                "name, such as main or prod."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStart)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStop)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdInfo)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoCreate)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoGet)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoLs)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoPut)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRepoRm)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStart)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdStop)

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("start-fast")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Force a checkpoint to start backup quickly.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Forces a checkpoint (by passing y to the fast parameter of pg_start_backup()) so the backup begins immediately. "
                "Otherwise the backup will start after the next regular checkpoint.\n"
            "\n"
            "This feature only works in PostgreSQL >= 8.4."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("stop-auto")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("backup")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Stop prior failed backup on new backup.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "This will only be done if an exclusive advisory lock can be acquired to demonstrate that the prior failed backup "
                "process has really stopped.\n"
            "\n"
            "This feature relies on pg_is_in_backup() so only works on PostgreSQL >= 9.3.\n"
            "\n"
            "This feature is not supported for PostgreSQL >= 9.6 since backups are run in non-exclusive mode.\n"
            "\n"
            "The setting is disabled by default because it assumes that pgBackRest is the only process doing exclusive online "
                "backups. It depends on an advisory lock that only pgBackRest sets so it may abort other processes that do "
                "exclusive online backups. Note that base_backup and pg_dump are safe to use with this setting because they do not "
                "call pg_start_backup() so are not exclusive."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("tablespace-map")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeHash)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Restore a tablespace into the specified directory.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Moves a tablespace to a new location during the restore. This is useful when tablespace locations are not the same on "
                "a replica, or an upgraded system has different mount points.\n"
            "\n"
            "Since PostgreSQL 9.2 tablespace locations are not stored in pg_tablespace so moving tablespaces can be done with "
                "impunity. However, moving a tablespace to the data_directory is not recommended and may cause problems. For more "
                "information on moving tablespaces http://www.databasesoup.com/2013/11/moving-tablespaces.html is a good resource."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("tablespace-map-all")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("restore")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Restore all tablespaces into the specified directory.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "By default tablespaces are restored into their original locations and while this behavior can be modified by with the "
                "tablespace-map open it is sometime preferable to remap all tablespaces to a new directory all at once. This is "
                "particularly useful for development or staging systems that may not have the same storage layout as the original "
                "system where the backup was generated.\n"
            "\n"
            "The path specified will be the parent path used to create all the tablespaces in the backup."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("target")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptType,
                    "name",
                    "time",
                    "xid"
                )

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Recovery target.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Defines the recovery target when --type is name, xid, or time."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("target-action")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
                (
                    "pause",
                    "promote",
                    "shutdown"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptType,
                    "immediate",
                    "name",
                    "time",
                    "xid"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("pause")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Action to take when recovery target is reached.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "This option is effective when hot_standby=on is configured in postgresql.conf, otherwise the cluster will be "
                        "promoted when the target is reached or there is no more WAL in the archive.\n"
                    "\n"
                    "The following actions are supported:\n"
                    "\n"
                    "* pause - pause when recovery target is reached. (PostgreSQL >= 9.1)\n"
                    "* promote - promote and switch timeline when recovery target is reached. (PostgreSQL >= 9.1)\n"
                    "* shutdown - shutdown server when recovery target is reached. (PostgreSQL >= 9.5)"
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("target-exclusive")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeBoolean)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptType,
                    "time",
                    "xid"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("0")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Stop just before the recovery target is reached.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "Defines whether recovery to the target would be exclusive (the default is inclusive) and is only valid when "
                        "--type is time or xid. For example, using --target-exclusive would exclude the contents of transaction "
                        "1007 when --type=xid and --target=1007. See the recovery_target_inclusive option in the PostgreSQL docs "
                        "for more information."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("target-timeline")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
                (
                    cfgDefOptType,
                    "default",
                    "name",
                    "standby",
                    "time",
                    "xid"
                )

                CFGDEFDATA_OPTION_OPTIONAL_REQUIRED(false)

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Recover along a timeline.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "See recovery_target_timeline in the PostgreSQL docs for more information."
                )
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("tcp-keep-alive-count")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Keep-alive count.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Specifies the number of TCP keep-alive messages that can be lost before the connection is considered dead.\n"
            "\n"
            "This option is available on systems that support the TCP_KEEPCNT socket option."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 32)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptSckKeepAlive,
                "1"
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("tcp-keep-alive-idle")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Keep-alive idle time.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Specifies the amount of time (in seconds) with no network activity after which the operating system should send a TCP "
                "keep-alive message.\n"
            "\n"
            "This option is available on systems that support the TCP_KEEPIDLE socket option."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 3600)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptSckKeepAlive,
                "1"
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("tcp-keep-alive-interval")
        CFGDEFDATA_OPTION_REQUIRED(false)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionGlobal)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeInteger)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_HELP_SECTION("general")
        CFGDEFDATA_OPTION_HELP_SUMMARY("Keep-alive interval time.")
        CFGDEFDATA_OPTION_HELP_DESCRIPTION
        (
            "Specifies the amount of time (in seconds) after which a TCP keep-alive message that has not been acknowledged should "
                "be retransmitted.\n"
            "\n"
            "This option is available on systems that support the TCP_KEEPINTVL socket option."
        )

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchiveGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdArchivePush)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdCheck)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdExpire)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdInfo)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoGet)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoLs)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoPut)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRepoRm)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaCreate)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaDelete)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdStanzaUpgrade)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_ALLOW_RANGE(1, 900)
            CFGDEFDATA_OPTION_OPTIONAL_DEPEND_LIST
            (
                cfgDefOptSckKeepAlive,
                "1"
            )
        )
    )

    // -----------------------------------------------------------------------------------------------------------------------------
    CFGDEFDATA_OPTION
    (
        CFGDEFDATA_OPTION_NAME("type")
        CFGDEFDATA_OPTION_REQUIRED(true)
        CFGDEFDATA_OPTION_SECTION(cfgDefSectionCommandLine)
        CFGDEFDATA_OPTION_TYPE(cfgDefOptTypeString)
        CFGDEFDATA_OPTION_INTERNAL(false)

        CFGDEFDATA_OPTION_INDEX_TOTAL(1)
        CFGDEFDATA_OPTION_SECURE(false)

        CFGDEFDATA_OPTION_COMMAND_LIST
        (
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdBackup)
            CFGDEFDATA_OPTION_COMMAND(cfgDefCmdRestore)
        )

        CFGDEFDATA_OPTION_OPTIONAL_LIST
        (
            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdBackup)

                CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
                (
                    "full",
                    "diff",
                    "incr"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("incr")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Backup type.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The following backup types are supported:\n"
                    "\n"
                    "* full - all database cluster files will be copied and there will be no dependencies on previous backups.\n"
                    "* incr - incremental from the last successful backup.\n"
                    "* diff - like an incremental backup but always based on the last full backup."
                )
            )

            CFGDEFDATA_OPTION_OPTIONAL_COMMAND_OVERRIDE
            (
                CFGDEFDATA_OPTION_OPTIONAL_COMMAND(cfgDefCmdRestore)

                CFGDEFDATA_OPTION_OPTIONAL_ALLOW_LIST
                (
                    "name",
                    "time",
                    "xid",
                    "preserve",
                    "none",
                    "immediate",
                    "default",
                    "standby"
                )

                CFGDEFDATA_OPTION_OPTIONAL_DEFAULT("default")

                CFGDEFDATA_OPTION_OPTIONAL_HELP_SUMMARY("Recovery type.")
                CFGDEFDATA_OPTION_OPTIONAL_HELP_DESCRIPTION
                (
                    "The following recovery types are supported:\n"
                    "\n"
                    "* default - recover to the end of the archive stream.\n"
                    "* immediate - recover only until the database becomes consistent. This option is only supported on PostgreSQL "
                        ">= 9.4.\n"
                    "* name - recover the restore point specified in --target.\n"
                    "* xid - recover to the transaction id specified in --target.\n"
                    "* time - recover to the time specified in --target.\n"
                    "* preserve - preserve the existing recovery.conf file.\n"
                    "* standby - add standby_mode=on to recovery.conf file so cluster will start in standby mode.\n"
                    "* none - no recovery.conf file is written so PostgreSQL will attempt to achieve consistency using WAL "
                        "segments present in pg_xlog/pg_wal. Provide the required WAL segments or use the archive-copy setting to "
                        "include them with the backup."
                )
            )
        )
    )
)
